/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.FilterTranslator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.utils.TypeHelper;
import java.util.Collection;
import java.util.HashSet;

public class RootCollectionPageTotalsQueryBuilder
extends AbstractHQLQueryBuilder {
    public RootCollectionPageTotalsQueryBuilder(EntityProjection entityProjection, EntityDictionary dictionary, Session session) {
        super(entityProjection, dictionary, session);
    }

    @Override
    public Query build() {
        String joinClause;
        String filterClause;
        HashSet<FilterPredicate> predicates;
        Class entityClass = this.entityProjection.getType();
        String entityName = entityClass.getCanonicalName();
        String entityAlias = TypeHelper.getTypeAlias((Class)entityClass);
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression != null) {
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)extractor);
            filterClause = " WHERE " + new FilterTranslator().apply(filterExpression, true);
            joinClause = this.getJoinClauseFromFilters(filterExpression, true);
        } else {
            predicates = new HashSet();
            filterClause = "";
            joinClause = "";
        }
        Query query = this.session.createQuery("SELECT COUNT(DISTINCT " + entityAlias + ") " + " FROM " + entityName + " AS " + entityAlias + " " + joinClause + " " + filterClause);
        this.supplyFilterQueryParameters(query, predicates);
        return query;
    }
}

