/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.FilterTranslator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.utils.TypeHelper;
import java.util.Collection;
import java.util.function.Function;

public class SubCollectionFetchQueryBuilder
extends AbstractHQLQueryBuilder {
    private final AbstractHQLQueryBuilder.Relationship relationship;

    public SubCollectionFetchQueryBuilder(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary, Session session) {
        super(relationship.getRelationship().getProjection(), dictionary, session);
        this.relationship = relationship;
    }

    @Override
    protected String extractToOneMergeJoins(Class<?> entityClass, String alias) {
        Function<String, Boolean> shouldSkip = relationshipName -> {
            String inverseRelationName = this.dictionary.getRelationInverse(entityClass, relationshipName);
            if (inverseRelationName.isEmpty()) {
                return false;
            }
            Class relationshipClass = this.dictionary.getParameterizedType(entityClass, relationshipName);
            return relationshipClass.equals(this.relationship.getParentType()) && inverseRelationName.equals(this.relationship.getRelationshipName());
        };
        return this.extractToOneMergeJoins(entityClass, alias, shouldSkip);
    }

    @Override
    public Query build() {
        Query query;
        if (this.entityProjection.getFilterExpression() == null && this.entityProjection.getPagination() == null && (this.entityProjection.getSorting() == null || this.entityProjection.getSorting().isDefaultInstance())) {
            return null;
        }
        String childAlias = TypeHelper.getTypeAlias(this.relationship.getChildType());
        String parentAlias = TypeHelper.getTypeAlias(this.relationship.getParentType()) + "__fetch";
        String parentName = this.relationship.getParentType().getCanonicalName();
        String relationshipName = this.relationship.getRelationshipName();
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression != null) {
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)extractor);
            String filterClause = new FilterTranslator().apply(filterExpression, true);
            String joinClause = this.getJoinClauseFromFilters(filterExpression) + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(this.relationship.getChildType(), childAlias);
            query = this.session.createQuery("SELECT " + childAlias + " FROM " + parentName + " " + parentAlias + " JOIN " + parentAlias + "." + relationshipName + " " + childAlias + joinClause + " WHERE " + filterClause + " AND " + parentAlias + "=:" + parentAlias + " " + this.getSortClause(this.entityProjection.getSorting()));
            this.supplyFilterQueryParameters(query, predicates);
        } else {
            query = this.session.createQuery("SELECT " + childAlias + " FROM " + parentName + " " + parentAlias + " JOIN " + parentAlias + "." + relationshipName + " " + childAlias + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(this.relationship.getChildType(), childAlias) + " WHERE " + parentAlias + "=:" + parentAlias + this.getSortClause(this.entityProjection.getSorting()));
        }
        query.setParameter(parentAlias, this.relationship.getParent());
        this.addPaginationToQuery(query);
        return query;
    }
}

