/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.filter.CaseAwareJPQLGenerator;
import com.yahoo.elide.core.filter.FilterOperation;
import com.yahoo.elide.core.filter.HasMemberJPQLGenerator;
import com.yahoo.elide.core.filter.JPQLPredicateGenerator;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class FilterTranslator
implements FilterOperation<String> {
    private static final String COMMA = ", ";
    private static Map<Operator, JPQLPredicateGenerator> operatorGenerators;
    private static Map<Triple<Operator, Type<?>, String>, JPQLPredicateGenerator> predicateOverrides;
    public static final Function<Path, String> GENERATE_HQL_COLUMN_NO_ALIAS;
    public static final Function<Path, String> GENERATE_HQL_COLUMN_WITH_ALIAS;
    private final EntityDictionary dictionary;

    public static void registerJPQLGenerator(Operator op, JPQLPredicateGenerator generator) {
        operatorGenerators.put(op, generator);
    }

    public static void registerJPQLGenerator(Operator op, Type<?> entityClass, String fieldName, JPQLPredicateGenerator generator) {
        predicateOverrides.put(Triple.of((Object)op, entityClass, (Object)fieldName), generator);
    }

    public static JPQLPredicateGenerator lookupJPQLGenerator(Operator op, Type<?> entityClass, String fieldName) {
        return predicateOverrides.get(Triple.of((Object)op, entityClass, (Object)fieldName));
    }

    public static JPQLPredicateGenerator lookupJPQLGenerator(Operator op) {
        return operatorGenerators.get(op);
    }

    public FilterTranslator(EntityDictionary dictionary) {
        this.dictionary = dictionary;
        if (!operatorGenerators.containsKey(Operator.HASMEMBER)) {
            operatorGenerators.put(Operator.HASMEMBER, new HasMemberJPQLGenerator(dictionary));
        }
        if (!operatorGenerators.containsKey(Operator.HASNOMEMBER)) {
            operatorGenerators.put(Operator.HASNOMEMBER, new HasMemberJPQLGenerator(dictionary, true));
        }
    }

    public String apply(FilterPredicate filterPredicate) {
        return this.apply(filterPredicate, GENERATE_HQL_COLUMN_NO_ALIAS);
    }

    protected String apply(FilterPredicate filterPredicate, Function<Path, String> aliasGenerator) {
        Function<Path, String> removeThisFromAlias = path -> {
            String fieldPath = (String)aliasGenerator.apply((Path)path);
            return fieldPath.replaceAll("\\.this", "");
        };
        Path.PathElement last = (Path.PathElement)filterPredicate.getPath().lastElement().get();
        Operator op = filterPredicate.getOperator();
        JPQLPredicateGenerator generator = FilterTranslator.lookupJPQLGenerator(op, last.getType(), last.getFieldName());
        if (generator == null) {
            generator = FilterTranslator.lookupJPQLGenerator(op);
        }
        if (generator == null) {
            throw new BadRequestException("Operator not implemented: " + filterPredicate.getOperator());
        }
        return generator.generate(filterPredicate, removeThisFromAlias);
    }

    private static String greatestClause(List<FilterPredicate.FilterParameter> params) {
        return String.format("greatest(%s)", params.stream().map(FilterPredicate.FilterParameter::getPlaceholder).collect(Collectors.joining(COMMA)));
    }

    private static String leastClause(List<FilterPredicate.FilterParameter> params) {
        return String.format("least(%s)", params.stream().map(FilterPredicate.FilterParameter::getPlaceholder).collect(Collectors.joining(COMMA)));
    }

    public String apply(FilterExpression filterExpression, boolean prefixWithAlias) {
        Function<Path, String> aliasGenerator = GENERATE_HQL_COLUMN_NO_ALIAS;
        if (prefixWithAlias) {
            aliasGenerator = GENERATE_HQL_COLUMN_WITH_ALIAS;
        }
        return this.apply(filterExpression, aliasGenerator);
    }

    public String apply(FilterExpression filterExpression, Function<Path, String> aliasGenerator) {
        JPQLQueryVisitor visitor = new JPQLQueryVisitor(aliasGenerator);
        return (String)filterExpression.accept((FilterExpressionVisitor)visitor);
    }

    static {
        GENERATE_HQL_COLUMN_NO_ALIAS = path -> path.getPathElements().stream().map(Path.PathElement::getFieldName).collect(Collectors.joining("."));
        GENERATE_HQL_COLUMN_WITH_ALIAS = path -> TypeHelper.getFieldAlias((String)TypeHelper.getPathAlias((Path)path), (String)path.lastElement().map(Path.PathElement::getFieldName).orElse(null));
        predicateOverrides = new HashMap();
        operatorGenerators = new EnumMap<Operator, JPQLPredicateGenerator>(Operator.class);
        operatorGenerators.put(Operator.IN, new CaseAwareJPQLGenerator("%s IN (%s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.IN_INSENSITIVE, new CaseAwareJPQLGenerator("%s IN (%s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.NOT, new CaseAwareJPQLGenerator("%s NOT IN (%s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.NOT_INSENSITIVE, new CaseAwareJPQLGenerator("%s NOT IN (%s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.PREFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.PREFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.POSTFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.POSTFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.INFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s, '%%')", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.INFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s, '%%')", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.LT, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s < %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.leastClause(predicate.getParameters()));
        });
        operatorGenerators.put(Operator.LE, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s <= %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.leastClause(predicate.getParameters()));
        });
        operatorGenerators.put(Operator.GT, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s > %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.greatestClause(predicate.getParameters()));
        });
        operatorGenerators.put(Operator.GE, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s >= %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.greatestClause(predicate.getParameters()));
        });
        operatorGenerators.put(Operator.ISNULL, (predicate, aliasGenerator) -> String.format("%s IS NULL", aliasGenerator.apply(predicate.getPath())));
        operatorGenerators.put(Operator.NOTNULL, (predicate, aliasGenerator) -> String.format("%s IS NOT NULL", aliasGenerator.apply(predicate.getPath())));
        operatorGenerators.put(Operator.TRUE, (predicate, aliasGenerator) -> "(1 = 1)");
        operatorGenerators.put(Operator.FALSE, (predicate, aliasGenerator) -> "(1 = 0)");
        operatorGenerators.put(Operator.ISEMPTY, (predicate, aliasGenerator) -> String.format("%s IS EMPTY", aliasGenerator.apply(predicate.getPath())));
        operatorGenerators.put(Operator.NOTEMPTY, (predicate, aliasGenerator) -> String.format("%s IS NOT EMPTY", aliasGenerator.apply(predicate.getPath())));
        operatorGenerators.put(Operator.BETWEEN, (predicate, aliasGenerator) -> {
            List parameters = predicate.getParameters();
            Preconditions.checkState((!parameters.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0);
            return String.format("%s BETWEEN %s AND %s", aliasGenerator.apply(predicate.getPath()), ((FilterPredicate.FilterParameter)parameters.get(0)).getPlaceholder(), ((FilterPredicate.FilterParameter)parameters.get(1)).getPlaceholder());
        });
        operatorGenerators.put(Operator.NOTBETWEEN, (predicate, aliasGenerator) -> {
            List parameters = predicate.getParameters();
            Preconditions.checkState((!parameters.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0);
            return String.format("%s NOT BETWEEN %s AND %s", aliasGenerator.apply(predicate.getPath()), ((FilterPredicate.FilterParameter)parameters.get(0)).getPlaceholder(), ((FilterPredicate.FilterParameter)parameters.get(1)).getPlaceholder());
        });
    }

    public class JPQLQueryVisitor
    implements FilterExpressionVisitor<String> {
        private Function<Path, String> aliasGenerator;

        public JPQLQueryVisitor(Function<Path, String> aliasGenerator) {
            this.aliasGenerator = aliasGenerator;
        }

        public String visitPredicate(FilterPredicate filterPredicate) {
            return FilterTranslator.this.apply(filterPredicate, this.aliasGenerator);
        }

        public String visitAndExpression(AndFilterExpression expression) {
            FilterExpression left = expression.getLeft();
            FilterExpression right = expression.getRight();
            return "(" + (String)left.accept((FilterExpressionVisitor)this) + " AND " + (String)right.accept((FilterExpressionVisitor)this) + ")";
        }

        public String visitOrExpression(OrFilterExpression expression) {
            FilterExpression left = expression.getLeft();
            FilterExpression right = expression.getRight();
            return "(" + (String)left.accept((FilterExpressionVisitor)this) + " OR " + (String)right.accept((FilterExpressionVisitor)this) + ")";
        }

        public String visitNotExpression(NotFilterExpression expression) {
            String negated = (String)expression.getNegated().accept((FilterExpressionVisitor)this);
            return "NOT (" + negated + ")";
        }
    }
}

