/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.FalsePredicate;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.ScrollableIteratorBase;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RelationshipImpl;
import com.yahoo.elide.core.hibernate.hql.RootCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RootCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.Type;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public abstract class JPQLTransaction
implements DataStoreTransaction {
    private final Session sessionWrapper;
    private final boolean isScrollEnabled;
    private final Set<Object> singleElementLoads;
    private final boolean delegateToInMemoryStore;

    protected JPQLTransaction(Session session, boolean delegateToInMemoryStore, boolean isScrollEnabled) {
        this.sessionWrapper = session;
        this.isScrollEnabled = isScrollEnabled;
        this.singleElementLoads = Collections.newSetFromMap(new IdentityHashMap());
        this.delegateToInMemoryStore = delegateToInMemoryStore;
    }

    public <T> T loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        Type entityClass = projection.getType();
        FilterExpression filterExpression = projection.getFilterExpression();
        EntityDictionary dictionary = scope.getDictionary();
        Type idType = dictionary.getIdType(entityClass);
        String idField = dictionary.getIdFieldName(entityClass);
        Path.PathElement idPath = new Path.PathElement(entityClass, idType, idField);
        Object idExpression = id != null ? new InPredicate(idPath, (Object[])new Serializable[]{id}) : new FalsePredicate(idPath);
        FalsePredicate joinedExpression = filterExpression != null ? new AndFilterExpression(filterExpression, (FilterExpression)idExpression) : idExpression;
        projection = projection.copyOf().filterExpression((FilterExpression)joinedExpression).build();
        Query query = new RootCollectionFetchQueryBuilder(projection, dictionary, this.sessionWrapper).build();
        return this.addSingleElement(query.uniqueResult());
    }

    public <T> Iterable<T> loadObjects(EntityProjection projection, RequestScope scope) {
        Iterable results;
        Pagination pagination = projection.getPagination();
        Query query = new RootCollectionFetchQueryBuilder(projection, scope.getDictionary(), this.sessionWrapper).build();
        Iterable iterable = results = this.isScrollEnabled ? query.scroll() : query.list();
        boolean hasResults = results instanceof Collection ? !((Collection)results).isEmpty() : (results instanceof Iterator ? ((Iterator)((Object)results)).hasNext() : results.iterator().hasNext());
        if (pagination != null && pagination.returnPageTotals() && (hasResults || pagination.getLimit() == 0)) {
            pagination.setPageTotals(this.getTotalRecords(projection, scope.getDictionary()));
        }
        return this.addSingleElement(results);
    }

    public <T, R> R getRelation(DataStoreTransaction relationTx, T entity, Relationship relation, RequestScope scope) {
        FilterExpression filterExpression = relation.getProjection().getFilterExpression();
        Sorting sorting = relation.getProjection().getSorting();
        Pagination pagination = relation.getProjection().getPagination();
        EntityDictionary dictionary = scope.getDictionary();
        Object val = PersistentResource.getValue(entity, (String)relation.getName(), (RequestScope)scope);
        if (val instanceof Collection && this.isPersistentCollection().test((Collection)val)) {
            Query query;
            if (filterExpression == null && sorting == null && (pagination == null || pagination.isDefaultInstance())) {
                return (R)this.addSingleElement(val);
            }
            RelationshipImpl relationship = new RelationshipImpl(dictionary.lookupEntityClass(EntityDictionary.getType(entity)), entity, relation);
            if (pagination != null && pagination.returnPageTotals()) {
                pagination.setPageTotals(this.getTotalRecords(relationship, scope.getDictionary()));
            }
            if ((query = new SubCollectionFetchQueryBuilder(relationship, dictionary, this.sessionWrapper).build()) != null) {
                return (R)this.addSingleElement(query.list());
            }
        }
        return (R)this.addSingleElement(val);
    }

    protected abstract Predicate<Collection<?>> isPersistentCollection();

    private Long getTotalRecords(EntityProjection entityProjection, EntityDictionary dictionary) {
        Query query = new RootCollectionPageTotalsQueryBuilder(entityProjection, dictionary, this.sessionWrapper).build();
        return (Long)query.uniqueResult();
    }

    private Long getTotalRecords(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary) {
        Query query = new SubCollectionPageTotalsQueryBuilder(relationship, dictionary, this.sessionWrapper).build();
        return (Long)query.uniqueResult();
    }

    private <R> R addSingleElement(R results) {
        if (results instanceof Iterable) {
            if (results instanceof ScrollableIteratorBase) {
                ((ScrollableIteratorBase)results).singletonElement().ifPresent(this.singleElementLoads::add);
            } else if (results instanceof Collection && ((Collection)results).size() == 1) {
                ((Collection)results).forEach(this.singleElementLoads::add);
            }
        } else if (results != null) {
            this.singleElementLoads.add(results);
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> boolean doInDatabase(Optional<T> parent) {
        if (!this.delegateToInMemoryStore) return true;
        if (!parent.isPresent()) return true;
        if (!parent.filter(this.singleElementLoads::contains).isPresent()) return false;
        return true;
    }

    public <T> DataStoreTransaction.FeatureSupport supportsFiltering(RequestScope scope, Optional<T> parent, EntityProjection projection) {
        return this.doInDatabase(parent) ? DataStoreTransaction.FeatureSupport.FULL : DataStoreTransaction.FeatureSupport.NONE;
    }

    public <T> boolean supportsSorting(RequestScope scope, Optional<T> parent, EntityProjection projection) {
        return this.doInDatabase(parent);
    }

    public <T> boolean supportsPagination(RequestScope scope, Optional<T> parent, EntityProjection projection) {
        return this.doInDatabase(parent);
    }
}

