/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public class ScrollableIteratorBase<T, R>
implements Iterable<T>,
Iterator<T> {
    private final R scroll;
    private final Predicate<R> nextFun;
    private final Function<R, T> getFun;
    private boolean inUse = false;
    private boolean hasNext = false;
    private T first;

    public ScrollableIteratorBase(R scroll, Predicate<R> nextFun, Function<R, T> getFun) {
        this.scroll = scroll;
        this.nextFun = nextFun;
        this.getFun = getFun;
        this.hasNext = nextFun.test(scroll);
        if (this.hasNext) {
            this.first = getFun.apply(scroll);
            this.hasNext = nextFun.test(scroll);
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.inUse) {
            throw new ConcurrentModificationException();
        }
        this.inUse = true;
        return Iterators.unmodifiableIterator((Iterator)this);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext || this.first != null;
    }

    @Override
    @NonNull
    public T next() {
        T row;
        if (!this.hasNext && this.first == null) {
            throw new NoSuchElementException();
        }
        if (this.first != null) {
            row = this.first;
            this.first = null;
        } else {
            row = this.getFun.apply(this.scroll);
            this.hasNext = this.nextFun.test(this.scroll);
        }
        Preconditions.checkNotNull(row);
        return row;
    }

    public Optional<T> singletonElement() {
        if (this.first != null && !this.hasNext) {
            return Optional.of(this.first);
        }
        return Optional.empty();
    }
}

