/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.query;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.FilterTranslator;
import com.yahoo.elide.datastores.jpql.porting.Query;
import com.yahoo.elide.datastores.jpql.porting.Session;
import com.yahoo.elide.datastores.jpql.query.AbstractHQLQueryBuilder;
import java.util.Collection;
import java.util.function.Predicate;

public class SubCollectionFetchQueryBuilder
extends AbstractHQLQueryBuilder {
    private final AbstractHQLQueryBuilder.Relationship relationship;

    public SubCollectionFetchQueryBuilder(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary, Session session) {
        super(relationship.getRelationship().getProjection(), dictionary, session);
        this.relationship = relationship;
    }

    @Override
    protected String extractToOneMergeJoins(Type<?> entityClass, String alias) {
        Predicate<String> shouldSkip = relationshipName -> {
            String inverseRelationName = this.dictionary.getRelationInverse(entityClass, relationshipName);
            if (inverseRelationName.isEmpty()) {
                return false;
            }
            Type relationshipClass = this.dictionary.getParameterizedType(entityClass, relationshipName);
            return relationshipClass.equals(this.relationship.getParentType()) && inverseRelationName.equals(this.relationship.getRelationshipName());
        };
        return this.extractToOneMergeJoins(entityClass, alias, shouldSkip);
    }

    @Override
    public Query build() {
        Query query;
        if (this.entityProjection.getFilterExpression() == null && this.entityProjection.getPagination() == null && (this.entityProjection.getSorting() == null || this.entityProjection.getSorting().isDefaultInstance())) {
            return null;
        }
        String childAlias = TypeHelper.getTypeAlias(this.relationship.getChildType());
        String parentAlias = TypeHelper.getTypeAlias(this.relationship.getParentType()) + "__fetch";
        String parentName = this.relationship.getParentType().getCanonicalName();
        String relationshipName = this.relationship.getRelationshipName();
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression != null) {
            boolean sortOverRelationship;
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)extractor);
            String filterClause = new FilterTranslator(this.dictionary).apply(filterExpression, true);
            String joinClause = this.getJoinClauseFromFilters(filterExpression) + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(this.relationship.getChildType(), childAlias);
            boolean requiresDistinct = this.containsOneToMany(filterExpression);
            boolean bl = sortOverRelationship = this.entityProjection.getSorting() != null && this.entityProjection.getSorting().getSortingPaths().keySet().stream().anyMatch(path -> path.getPathElements().stream().anyMatch(element -> this.dictionary.isRelation(element.getType(), element.getFieldName())));
            if (requiresDistinct && sortOverRelationship) {
                throw new InvalidValueException((Object)"Combination of sorting over relationship and filtering over toMany relationships unsupported");
            }
            query = this.session.createQuery("SELECT " + (requiresDistinct ? "DISTINCT " : "") + childAlias + " FROM " + parentName + " " + parentAlias + " JOIN " + parentAlias + "." + relationshipName + " " + childAlias + joinClause + " WHERE " + filterClause + " AND " + parentAlias + "=:" + parentAlias + " " + this.getSortClause(this.entityProjection.getSorting()));
            this.supplyFilterQueryParameters(query, predicates);
        } else {
            query = this.session.createQuery("SELECT " + childAlias + " FROM " + parentName + " " + parentAlias + " JOIN " + parentAlias + "." + relationshipName + " " + childAlias + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(this.relationship.getChildType(), childAlias) + " WHERE " + parentAlias + "=:" + parentAlias + this.getSortClause(this.entityProjection.getSorting()));
        }
        query.setParameter(parentAlias, this.relationship.getParent());
        this.addPaginationToQuery(query);
        return query;
    }
}

