/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.query;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.ExpressionScopingVisitor;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.jpql.filter.FilterTranslator;
import com.yahoo.elide.datastores.jpql.porting.Query;
import com.yahoo.elide.datastores.jpql.porting.Session;
import com.yahoo.elide.datastores.jpql.query.AbstractHQLQueryBuilder;
import java.util.ArrayList;
import java.util.Collection;

public class SubCollectionPageTotalsQueryBuilder
extends AbstractHQLQueryBuilder {
    private final AbstractHQLQueryBuilder.Relationship relationship;

    public SubCollectionPageTotalsQueryBuilder(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary, Session session) {
        super(relationship.getRelationship().getProjection(), dictionary, session);
        this.relationship = relationship;
    }

    @Override
    public Query build() {
        Type parentType = this.dictionary.lookupEntityClass(this.relationship.getParentType());
        Type idType = this.dictionary.getIdType(parentType);
        Object idVal = CoerceUtil.coerce((Object)this.dictionary.getId(this.relationship.getParent()), (Type)idType);
        String idField = this.dictionary.getIdFieldName(parentType);
        InPredicate idExpression = new InPredicate(new Path.PathElement(parentType, idType, idField), new Object[]{idVal});
        ArrayList<FilterPredicate> predicates = new ArrayList<InPredicate>();
        Object joinClause = "";
        String filterClause = "";
        String relationshipName = this.relationship.getRelationshipName();
        String parentAlias = TypeHelper.getTypeAlias((Type)parentType);
        String relationshipAlias = TypeHelper.appendAlias((String)parentAlias, (String)relationshipName);
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression != null) {
            ExpressionScopingVisitor visitor = new ExpressionScopingVisitor(new Path.PathElement(parentType, this.relationship.getChildType(), this.relationship.getRelationshipName()));
            FilterExpression scoped = (FilterExpression)filterExpression.accept((FilterExpressionVisitor)visitor);
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor(new ArrayList());
            predicates = (Collection)scoped.accept((FilterExpressionVisitor)extractor);
            predicates.add((FilterPredicate)idExpression);
            AndFilterExpression joinedExpression = new AndFilterExpression(scoped, (FilterExpression)idExpression);
            joinClause = this.getJoinClauseFromFilters((FilterExpression)joinedExpression, true);
            filterClause = new FilterTranslator(this.dictionary).apply((FilterExpression)joinedExpression, true);
        } else {
            joinClause = " JOIN " + parentAlias + "." + relationshipName + " " + relationshipAlias + " ";
            filterClause = new FilterTranslator(this.dictionary).apply((FilterExpression)idExpression, true);
            predicates.add((FilterPredicate)idExpression);
        }
        Query query = this.session.createQuery("SELECT COUNT(DISTINCT " + relationshipAlias + ")  FROM " + parentType.getCanonicalName() + " AS " + parentAlias + " " + (String)joinClause + " WHERE " + filterClause);
        this.supplyFilterQueryParameters(query, predicates);
        return query;
    }
}

