/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.FilterScope;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.datastores.hibernate3.filter.CriterionFilterOperation;
import com.yahoo.elide.datastores.hibernate3.security.CriteriaCheck;
import com.yahoo.elide.security.Check;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.collection.PersistentBag;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;

public class HibernateStore
implements DataStore {
    private final HQLFilterOperation hqlFilterOperation = new HQLFilterOperation();
    private final CriterionFilterOperation criterionFilterOperation = new CriterionFilterOperation();
    private final SessionFactory sessionFactory;

    public HibernateStore(SessionFactory aSessionFactory) {
        this.sessionFactory = aSessionFactory;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (ClassMetadata meta : this.sessionFactory.getAllClassMetadata().values()) {
            dictionary.bindEntity(meta.getMappedClass(EntityMode.POJO));
        }
    }

    public org.hibernate.Session getSession() {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Preconditions.checkNotNull((Object)session);
            Preconditions.checkArgument((boolean)session.isConnected());
            return session;
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public DataStoreTransaction beginTransaction() {
        Session session = this.sessionFactory.getCurrentSession();
        Preconditions.checkNotNull((Object)session);
        return new HibernateTransaction(session.beginTransaction());
    }

    public class HibernateTransaction
    implements DataStoreTransaction {
        private final Transaction transaction;
        private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();

        public HibernateTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        public void delete(Object object) {
            this.deferredTasks.add(() -> HibernateStore.this.getSession().delete(object));
        }

        public void save(Object object) {
            this.deferredTasks.add(() -> HibernateStore.this.getSession().saveOrUpdate(object));
        }

        public void flush() {
            try {
                this.deferredTasks.forEach(Runnable::run);
                this.deferredTasks.clear();
                HibernateStore.this.getSession().flush();
            }
            catch (HibernateException e) {
                throw new TransactionException((Throwable)e);
            }
        }

        public void commit() {
            try {
                this.flush();
                this.transaction.commit();
            }
            catch (HibernateException e) {
                throw new TransactionException((Throwable)e);
            }
        }

        public <T> T createObject(Class<T> entityClass) {
            try {
                Object object = entityClass.newInstance();
                this.deferredTasks.add(() -> HibernateStore.this.getSession().persist(object));
                return object;
            }
            catch (IllegalAccessException | InstantiationException e) {
                return null;
            }
        }

        public <T> T loadObject(Class<T> loadClass, Serializable id) {
            Object record = null;
            try {
                record = HibernateStore.this.getSession().load(loadClass, id);
                Hibernate.initialize((Object)record);
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
            return (T)record;
        }

        public <T> Iterable<T> loadObjects(Class<T> loadClass) {
            ScrollableIterator list = new ScrollableIterator(HibernateStore.this.getSession().createCriteria(loadClass).scroll(ScrollMode.FORWARD_ONLY));
            return list;
        }

        public <T> Iterable<T> loadObjects(Class<T> loadClass, FilterScope<T> filterScope) {
            Criterion criterion = this.buildCheckCriterion(filterScope);
            String type = filterScope.getRequestScope().getDictionary().getBinding(loadClass);
            Set filteredPredicates = filterScope.getRequestScope().getPredicatesOfType(type);
            if ((criterion = CriterionFilterOperation.andWithNull(criterion, HibernateStore.this.criterionFilterOperation.applyAll((Set<Predicate>)filteredPredicates))) == null) {
                return this.loadObjects(loadClass);
            }
            ScrollableIterator list = new ScrollableIterator(HibernateStore.this.getSession().createCriteria(loadClass).add(criterion).scroll(ScrollMode.FORWARD_ONLY));
            return list;
        }

        public <T> Criterion buildCheckCriterion(FilterScope<T> filterScope) {
            Criterion compositeCriterion = null;
            List checks = filterScope.getChecks();
            RequestScope requestScope = filterScope.getRequestScope();
            block4: for (Check check : checks) {
                Criterion criterion = check instanceof CriteriaCheck ? ((CriteriaCheck)check).getCriterion(requestScope) : null;
                if (criterion == null) {
                    switch (filterScope.getRequestScope().getUser().checkUserPermission(check)) {
                        case ALLOW: {
                            if (filterScope.isAny()) break;
                            continue block4;
                        }
                        case DENY: {
                            if (!filterScope.isAny()) break;
                            continue block4;
                        }
                    }
                    return null;
                }
                if (compositeCriterion == null) {
                    compositeCriterion = criterion;
                    continue;
                }
                if (filterScope.isAny()) {
                    compositeCriterion = Restrictions.or((Criterion)compositeCriterion, (Criterion)criterion);
                    continue;
                }
                compositeCriterion = Restrictions.and((Criterion)compositeCriterion, (Criterion)criterion);
            }
            return compositeCriterion;
        }

        public <T> Collection filterCollection(Collection collection, Class<T> entityClass, Set<Predicate> predicates) {
            String filterString;
            if (collection instanceof PersistentBag && !predicates.isEmpty() && (filterString = HibernateStore.this.hqlFilterOperation.applyAll(predicates)).length() != 0) {
                Query query = HibernateStore.this.getSession().createFilter((Object)collection, filterString);
                for (Predicate predicate : predicates) {
                    if (!predicate.getOperator().isParameterized()) continue;
                    query = query.setParameterList(predicate.getField(), (Collection)predicate.getValues());
                }
                return query.list();
            }
            return collection;
        }

        public void close() throws IOException {
            if (this.transaction.isActive()) {
                this.transaction.rollback();
                throw new IOException("Transaction not closed");
            }
        }

        public User accessUser(Object opaqueUser) {
            return new User(opaqueUser);
        }
    }

    public static class ScrollableIterator<T>
    implements Iterable<T>,
    Iterator<T> {
        private final ScrollableResults scroll;
        private boolean inUse = false;
        private boolean hasNext;

        public ScrollableIterator(ScrollableResults scroll) {
            this.scroll = scroll;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.inUse) {
                throw new ConcurrentModificationException();
            }
            if (!this.scroll.first()) {
                return Collections.emptyListIterator();
            }
            this.inUse = true;
            this.hasNext = true;
            return Iterators.unmodifiableIterator((Iterator)this);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @NonNull
        public T next() {
            Object row = this.scroll.get()[0];
            Preconditions.checkNotNull((Object)row);
            this.hasNext = this.scroll.next();
            return (T)row;
        }
    }
}

