/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.FilterScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.datastores.hibernate3.ScrollableIterator;
import com.yahoo.elide.datastores.hibernate3.filter.CriterionFilterOperation;
import com.yahoo.elide.datastores.hibernate3.security.CriteriaCheck;
import com.yahoo.elide.security.RequestScope;
import com.yahoo.elide.security.User;
import com.yahoo.elide.security.checks.InlineCheck;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class HibernateTransaction
implements DataStoreTransaction {
    private final Session session;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final HQLFilterOperation hqlFilterOperation = new HQLFilterOperation();
    private final CriterionFilterOperation criterionFilterOperation = new CriterionFilterOperation();

    public HibernateTransaction(Session session) {
        this.session = session;
    }

    public void delete(Object object) {
        this.deferredTasks.add(() -> this.session.delete(object));
    }

    public void save(Object object) {
        this.deferredTasks.add(() -> this.session.saveOrUpdate(object));
    }

    public void flush() {
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            this.session.flush();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void commit() {
        try {
            this.flush();
            this.session.getTransaction().commit();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public <T> T createObject(Class<T> entityClass) {
        try {
            Object object = entityClass.newInstance();
            this.deferredTasks.add(() -> this.session.persist(object));
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public <T> T loadObject(Class<T> loadClass, Serializable id) {
        try {
            Object record = this.session.load(loadClass, id);
            Hibernate.initialize((Object)record);
            return (T)record;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass) {
        ScrollableIterator list = new ScrollableIterator(this.session.createCriteria(loadClass).scroll(ScrollMode.FORWARD_ONLY));
        return list;
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass, FilterScope filterScope) {
        Criterion criterion = this.buildCheckCriterion(filterScope);
        String type = filterScope.getRequestScope().getDictionary().getBinding(loadClass);
        Set filteredPredicates = filterScope.getRequestScope().getPredicatesOfType(type);
        if ((criterion = CriterionFilterOperation.andWithNull(criterion, this.criterionFilterOperation.applyAll((Set<Predicate>)filteredPredicates))) == null) {
            return this.loadObjects(loadClass);
        }
        ScrollableIterator list = new ScrollableIterator(this.session.createCriteria(loadClass).add(criterion).scroll(ScrollMode.FORWARD_ONLY));
        return list;
    }

    public Criterion buildCheckCriterion(FilterScope filterScope) {
        Criterion compositeCriterion = null;
        List checks = filterScope.getInlineChecks();
        com.yahoo.elide.core.RequestScope requestScope = filterScope.getRequestScope();
        for (InlineCheck check : checks) {
            Criterion criterion = null;
            if (check instanceof CriteriaCheck) {
                criterion = ((CriteriaCheck)check).getCriterion((RequestScope)requestScope);
            }
            if (compositeCriterion == null) {
                compositeCriterion = criterion;
                continue;
            }
            if (filterScope.isAny()) {
                compositeCriterion = Restrictions.or((Criterion)compositeCriterion, (Criterion)criterion);
                continue;
            }
            compositeCriterion = Restrictions.and((Criterion)compositeCriterion, (Criterion)criterion);
        }
        return compositeCriterion;
    }

    public <T> Collection filterCollection(Collection collection, Class<T> entityClass, Set<Predicate> predicates) {
        String filterString;
        if (collection instanceof AbstractPersistentCollection && !predicates.isEmpty() && (filterString = this.hqlFilterOperation.applyAll(predicates)).length() != 0) {
            Query query = this.session.createFilter((Object)collection, filterString);
            for (Predicate predicate : predicates) {
                if (!predicate.getOperator().isParameterized()) continue;
                query = query.setParameterList(predicate.getField(), (Collection)predicate.getValues());
            }
            return query.list();
        }
        return collection;
    }

    public void close() throws IOException {
        if (this.session.isOpen() && this.session.getTransaction().isActive()) {
            this.session.getTransaction().rollback();
            throw new IOException("Transaction not closed");
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }
}

