/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3.filter;

import com.yahoo.elide.core.exceptions.InvalidPredicateException;
import com.yahoo.elide.core.filter.FilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import java.util.Collection;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CriterionFilterOperation
implements FilterOperation<Criterion> {
    public Criterion apply(Predicate predicate) {
        switch (predicate.getOperator()) {
            case IN: {
                return Restrictions.in((String)predicate.getField(), (Collection)predicate.getValues());
            }
            case NOT: {
                return Restrictions.not((Criterion)Restrictions.in((String)predicate.getField(), (Collection)predicate.getValues()));
            }
            case PREFIX: {
                return Restrictions.like((String)predicate.getField(), (Object)(predicate.getValues().get(0) + "%"));
            }
            case POSTFIX: {
                return Restrictions.like((String)predicate.getField(), (Object)("%" + predicate.getValues().get(0)));
            }
            case INFIX: {
                return Restrictions.like((String)predicate.getField(), (Object)("%" + predicate.getValues().get(0) + "%"));
            }
            case ISNULL: {
                return Restrictions.isNull((String)predicate.getField());
            }
            case NOTNULL: {
                return Restrictions.isNotNull((String)predicate.getField());
            }
            case LT: {
                return Restrictions.lt((String)predicate.getField(), predicate.getValues().get(0));
            }
            case LE: {
                return Restrictions.le((String)predicate.getField(), predicate.getValues().get(0));
            }
            case GT: {
                return Restrictions.gt((String)predicate.getField(), predicate.getValues().get(0));
            }
            case GE: {
                return Restrictions.ge((String)predicate.getField(), predicate.getValues().get(0));
            }
        }
        throw new InvalidPredicateException("Operator not implemented: " + predicate.getOperator());
    }

    public Criterion applyAll(Set<Predicate> predicates) {
        Criterion result = null;
        for (Predicate predicate : predicates) {
            result = CriterionFilterOperation.andWithNull(result, this.apply(predicate));
        }
        return result;
    }

    public static Criterion andWithNull(Criterion lhs, Criterion rhs) {
        if (lhs == null && rhs == null) {
            return null;
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return Restrictions.and((Criterion)lhs, (Criterion)rhs);
    }
}

