/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.expression.Visitor;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;

public class HQLTransaction {

    public static class Builder<T> {
        private final Session session;
        private final Collection collection;
        private final Class<T> entityClass;
        private final EntityDictionary dictionary;
        private Set<Predicate> filters = null;
        private String sortingRules = "";
        private Pagination pagination = null;
        private FilterExpression filterExpression = null;

        public Builder(Session session, Collection collection, Class<T> entityClass, EntityDictionary dictionary) {
            this.session = session;
            this.collection = collection;
            this.entityClass = entityClass;
            this.dictionary = dictionary;
        }

        public Builder withPossibleFilterExpression(Optional<FilterExpression> filterExpression) {
            if (filterExpression.isPresent()) {
                return this.withFilterExpression(filterExpression.get());
            }
            return this;
        }

        public Builder withFilterExpression(FilterExpression filterExpression) {
            this.filterExpression = filterExpression;
            PredicateExtractionVisitor visitor = new PredicateExtractionVisitor();
            this.filters = (Set)filterExpression.accept((Visitor)visitor);
            return this;
        }

        public Builder withPossibleFilters(Optional<Set<Predicate>> possibleFilters) {
            if (possibleFilters.isPresent()) {
                return this.withFilters(possibleFilters.get());
            }
            return this;
        }

        public Builder withFilters(Set<Predicate> filters) {
            if (filters != null && !filters.isEmpty()) {
                this.filters = filters;
            }
            return this;
        }

        public Builder withPossibleSorting(Optional<Sorting> possibleSorting) {
            if (possibleSorting.isPresent()) {
                return this.withSorting(possibleSorting.get());
            }
            return this;
        }

        public Builder withSorting(Sorting sorting) {
            Map validSortingRules;
            if (sorting != null && !sorting.isDefaultInstance() && !(validSortingRules = sorting.getValidSortingRules(this.entityClass, this.dictionary)).isEmpty()) {
                ArrayList ordering = new ArrayList();
                validSortingRules.entrySet().stream().forEachOrdered(entry -> ordering.add((String)entry.getKey() + " " + (((Sorting.SortOrder)entry.getValue()).equals((Object)Sorting.SortOrder.desc) ? "desc" : "asc")));
                this.sortingRules = this.sortingRules + "order by " + StringUtils.join(ordering, (String)",");
            }
            return this;
        }

        public Builder withPossiblePagination(Optional<Pagination> possiblePagination) {
            if (possiblePagination.isPresent()) {
                return this.withPagination(possiblePagination.get());
            }
            return this;
        }

        public Builder withPagination(Pagination pagination) {
            if (pagination != null) {
                this.pagination = pagination;
            }
            return this;
        }

        public Optional<Query> build() {
            String filterString = "";
            if (this.filterExpression != null) {
                filterString = filterString + new HQLFilterOperation().apply(this.filterExpression);
            } else if (this.filters != null) {
                filterString = filterString + new HQLFilterOperation().applyAll(this.filters);
            }
            if (this.sortingRules != null && !this.sortingRules.isEmpty()) {
                filterString = filterString + this.sortingRules;
            }
            Query query = null;
            if (filterString.length() != 0) {
                query = this.session.createFilter((Object)this.collection, filterString);
                if (this.filters != null) {
                    for (Predicate predicate : this.filters) {
                        if (!predicate.getOperator().isParameterized()) continue;
                        String name = predicate.getFieldPath().replace('.', '_');
                        query = query.setParameterList(name, (Collection)predicate.getValues());
                    }
                }
            }
            if (this.pagination != null) {
                if (query == null) {
                    query = this.session.createFilter((Object)this.collection, "");
                }
                query.setFirstResult(this.pagination.getOffset());
                query.setMaxResults(this.pagination.getLimit());
            }
            return Optional.ofNullable(query);
        }
    }
}

