/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3;

import com.google.common.base.Objects;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.FilterScope;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScopedTransaction;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.datastores.hibernate3.HQLTransaction;
import com.yahoo.elide.datastores.hibernate3.ScrollableIterator;
import com.yahoo.elide.datastores.hibernate3.filter.CriterionFilterOperation;
import com.yahoo.elide.security.RequestScope;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class HibernateTransaction
implements RequestScopedTransaction {
    private static final Function<Criterion, Criterion> NOT = Restrictions::not;
    private static final BiFunction<Criterion, Criterion, Criterion> AND = Restrictions::and;
    private static final BiFunction<Criterion, Criterion, Criterion> OR = Restrictions::or;
    private final Session session;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final boolean isScrollEnabled;
    private final ScrollMode scrollMode;
    private com.yahoo.elide.core.RequestScope requestScope = null;

    @Deprecated
    public HibernateTransaction(Session session) {
        this.session = session;
        this.isScrollEnabled = true;
        this.scrollMode = ScrollMode.FORWARD_ONLY;
    }

    protected HibernateTransaction(Session session, boolean isScrollEnabled, ScrollMode scrollMode) {
        this.session = session;
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
    }

    public void delete(Object object) {
        this.deferredTasks.add(() -> this.session.delete(object));
    }

    public void save(Object object) {
        this.deferredTasks.add(() -> this.session.saveOrUpdate(object));
    }

    public void flush() {
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            this.session.flush();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void commit() {
        try {
            this.flush();
            this.session.getTransaction().commit();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public <T> T createObject(Class<T> entityClass) {
        try {
            Object object = entityClass.newInstance();
            this.deferredTasks.add(() -> this.session.persist(object));
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @Deprecated
    public <T> T loadObject(Class<T> loadClass, Serializable id) {
        try {
            if (this.isJoinQuery()) {
                Criteria criteria = this.session.createCriteria(loadClass).add(Restrictions.idEq((Object)id));
                if (this.requestScope != null) {
                    this.joinCriteria(criteria, loadClass);
                }
                Object record = criteria.uniqueResult();
                return (T)record;
            }
            Object record = this.session.get(loadClass, id);
            return (T)record;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public <T> T loadObject(Class<T> loadClass, Serializable id, Optional<FilterExpression> filterExpression) {
        try {
            if (!filterExpression.isPresent() && !this.isJoinQuery()) {
                Object record = this.session.get(loadClass, id);
                return (T)record;
            }
            Criteria criteria = this.session.createCriteria(loadClass).add(Restrictions.idEq((Object)id));
            if (this.requestScope != null && this.isJoinQuery()) {
                this.joinCriteria(criteria, loadClass);
            }
            if (filterExpression.isPresent()) {
                CriterionFilterOperation filterOpn = this.buildCriterionFilterOperation(criteria);
                criteria = filterOpn.apply(filterExpression.get());
            }
            Object record = criteria.uniqueResult();
            return (T)record;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    protected CriterionFilterOperation buildCriterionFilterOperation(Criteria criteria) {
        return new CriterionFilterOperation(criteria);
    }

    @Deprecated
    public <T> Iterable<T> loadObjects(Class<T> loadClass) {
        throw new IllegalStateException("" + loadClass);
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass, FilterScope filterScope) {
        Criterion securityCriterion = (Criterion)filterScope.getCriterion(NOT, AND, OR);
        Optional filterExpression = filterScope.getRequestScope().getLoadFilterExpression(loadClass);
        Criteria criteria = this.session.createCriteria(loadClass);
        if (securityCriterion != null) {
            criteria.add(securityCriterion);
        }
        if (filterExpression.isPresent()) {
            CriterionFilterOperation filterOpn = this.buildCriterionFilterOperation(criteria);
            criteria = filterOpn.apply((FilterExpression)filterExpression.get());
        }
        return this.loadObjects(loadClass, criteria, Optional.empty(), Optional.empty());
    }

    public <T> Iterable<T> loadObjectsWithSortingAndPagination(Class<T> entityClass, FilterScope filterScope) {
        Criterion securityCriterion = (Criterion)filterScope.getCriterion(NOT, AND, OR);
        Optional filterExpression = filterScope.getRequestScope().getLoadFilterExpression(entityClass);
        Criteria criteria = this.session.createCriteria(entityClass);
        if (securityCriterion != null) {
            criteria.add(securityCriterion);
        }
        if (filterExpression.isPresent()) {
            CriterionFilterOperation filterOpn = this.buildCriterionFilterOperation(criteria);
            criteria = filterOpn.apply((FilterExpression)filterExpression.get());
        }
        Pagination pagination = filterScope.getRequestScope().getPagination();
        Set validatedSortingRules = null;
        if (filterScope.hasSortingRules()) {
            Sorting sorting = filterScope.getRequestScope().getSorting();
            EntityDictionary dictionary = filterScope.getRequestScope().getDictionary();
            validatedSortingRules = sorting.getValidSortingRules(entityClass, dictionary).entrySet().stream().map(entry -> ((Sorting.SortOrder)entry.getValue()).equals((Object)Sorting.SortOrder.desc) ? Order.desc((String)((String)entry.getKey())) : Order.asc((String)((String)entry.getKey()))).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.loadObjects(entityClass, criteria, Optional.ofNullable(validatedSortingRules), Optional.ofNullable(pagination));
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass, Criteria criteria, Optional<Set<Order>> sortingRules, Optional<Pagination> pagination) {
        if (sortingRules.isPresent()) {
            sortingRules.get().forEach(arg_0 -> ((Criteria)criteria).addOrder(arg_0));
        }
        if (pagination.isPresent()) {
            Pagination paginationData = pagination.get();
            paginationData.evaluate(loadClass);
            criteria.setFirstResult(paginationData.getOffset());
            criteria.setMaxResults(paginationData.getLimit());
        } else {
            Integer queryLimit = this.getQueryLimit();
            if (queryLimit != null) {
                criteria.setMaxResults(queryLimit.intValue());
            }
        }
        if (this.isJoinQuery()) {
            this.joinCriteria(criteria, loadClass);
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (!this.isScrollEnabled || this.isJoinQuery()) {
            return criteria.list();
        }
        return new ScrollableIterator(criteria.scroll(this.scrollMode));
    }

    public <T> Long getTotalRecords(Class<T> entityClass) {
        Criteria sessionCriteria = this.session.createCriteria(entityClass);
        sessionCriteria.setProjection(Projections.rowCount());
        return (Long)sessionCriteria.uniqueResult();
    }

    public boolean isJoinQuery() {
        return false;
    }

    private <T> void joinCriteria(Criteria criteria, Class<T> loadClass) {
        EntityDictionary dictionary = this.requestScope.getDictionary();
        String type = dictionary.getJsonAliasFor(loadClass);
        Set fields = (Set)Objects.firstNonNull(this.requestScope.getSparseFields().get(type), Collections.emptySet());
        for (String field : fields) {
            try {
                this.checkFieldReadPermission(loadClass, field);
                criteria.setFetchMode(field, FetchMode.JOIN);
            }
            catch (ForbiddenAccessException e) {}
        }
        for (String include : this.getIncludeList()) {
            criteria.setFetchMode(include, FetchMode.JOIN);
        }
    }

    public List<String> getIncludeList() {
        if (!this.requestScope.getQueryParams().isPresent()) {
            return Collections.emptyList();
        }
        List includeParam = (List)((MultivaluedMap)this.requestScope.getQueryParams().get()).get((Object)"include");
        if (includeParam == null || includeParam.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String includeList : includeParam) {
            for (String includeItem : includeList.split(",")) {
                int idx = 0;
                while (idx != -1) {
                    String field = (idx = includeItem.indexOf(46, idx + 1)) == -1 ? includeItem : includeItem.substring(0, idx);
                    list.add(field);
                }
            }
        }
        return list;
    }

    private <T> void checkFieldReadPermission(final Class<T> loadClass, String field) {
        com.yahoo.elide.security.PersistentResource resource = new com.yahoo.elide.security.PersistentResource<T>(){

            public boolean matchesId(String id) {
                return false;
            }

            public Optional<String> getUUID() {
                return Optional.empty();
            }

            public String getId() {
                return null;
            }

            public String getType() {
                return null;
            }

            public T getObject() {
                return null;
            }

            public Class<T> getResourceClass() {
                return loadClass;
            }

            public RequestScope getRequestScope() {
                return HibernateTransaction.this.requestScope;
            }
        };
        this.requestScope.getPermissionExecutor().checkUserPermissions(resource, ReadPermission.class, field);
    }

    public <T> Object getRelation(Object entity, RelationshipType relationshipType, String relationName, Class<T> relationClass, EntityDictionary dictionary, Optional<FilterExpression> filterExpression, Sorting sorting, Pagination pagination) {
        Collection filteredVal;
        Object val = PersistentResource.getValue((Object)entity, (String)relationName, (EntityDictionary)dictionary);
        if (val instanceof Collection && (filteredVal = (Collection)val) instanceof AbstractPersistentCollection) {
            Optional<Sorting> sortingRules = sorting != null ? Optional.of(sorting) : Optional.empty();
            Optional<Pagination> paginationRules = pagination != null ? Optional.of(pagination) : Optional.empty();
            Optional<Query> possibleQuery = new HQLTransaction.Builder<T>(this.session, filteredVal, relationClass, dictionary).withPossibleFilterExpression(filterExpression).withPossibleSorting(sortingRules).withPossiblePagination(paginationRules).build();
            if (possibleQuery.isPresent()) {
                return possibleQuery.get().list();
            }
        }
        return val;
    }

    @Deprecated
    public <T> Collection filterCollection(Collection collection, Class<T> entityClass, Set<Predicate> predicates) {
        String filterString;
        if (collection instanceof AbstractPersistentCollection && !predicates.isEmpty() && (filterString = new HQLFilterOperation().applyAll(predicates)).length() != 0) {
            Query query = this.session.createFilter((Object)collection, filterString);
            for (Predicate predicate : predicates) {
                if (!predicate.getOperator().isParameterized()) continue;
                String name = predicate.getFieldPath().replace('.', '_');
                query = query.setParameterList(name, (Collection)predicate.getValues());
            }
            return query.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
        }
        return collection;
    }

    @Deprecated
    public <T> Collection filterCollectionWithSortingAndPagination(Collection collection, Class<T> entityClass, EntityDictionary dictionary, Optional<Set<Predicate>> filters, Optional<Sorting> sorting, Optional<Pagination> pagination) {
        Optional<Query> possibleQuery;
        if (collection instanceof AbstractPersistentCollection && (filters.isPresent() || sorting.isPresent() || pagination.isPresent()) && (possibleQuery = new HQLTransaction.Builder<T>(this.session, collection, entityClass, dictionary).withPossibleFilters(filters).withPossibleSorting(sorting).withPossiblePagination(pagination).build()).isPresent()) {
            return possibleQuery.get().list();
        }
        return collection;
    }

    public void close() throws IOException {
        if (this.session.isOpen() && this.session.getTransaction().isActive()) {
            this.session.getTransaction().rollback();
            throw new IOException("Transaction not closed");
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }

    public void setRequestScope(com.yahoo.elide.core.RequestScope requestScope) {
        this.requestScope = requestScope;
    }

    public Integer getQueryLimit() {
        return null;
    }

    protected com.yahoo.elide.core.RequestScope getRequestScope() {
        return this.requestScope;
    }
}

