/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3.filter;

import com.yahoo.elide.core.exceptions.InvalidPredicateException;
import com.yahoo.elide.core.filter.FilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.expression.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriterionFilterOperation
implements FilterOperation<Criterion> {
    private static final Logger log = LoggerFactory.getLogger(CriterionFilterOperation.class);
    private final Criteria criteria;
    private static String ALIAS_DELIM = "__";

    public CriterionFilterOperation(Criteria criteria) {
        this.criteria = criteria;
    }

    private static String getAlias(List<Predicate.PathElement> path) {
        StringBuilder sb = new StringBuilder();
        Predicate.PathElement first = path.get(0);
        sb.append(first.getTypeName());
        sb.append(ALIAS_DELIM);
        sb.append(first.getFieldName());
        for (int i = 1; i < path.size() - 1; ++i) {
            Predicate.PathElement element = path.get(i);
            sb.append(ALIAS_DELIM);
            sb.append(element.getFieldName());
        }
        return sb.toString().replace('-', '_');
    }

    private static String getAssociationPath(List<Predicate.PathElement> path) {
        StringBuilder sb = new StringBuilder();
        Predicate.PathElement first = path.get(0);
        sb.append(first.getFieldName());
        for (int i = 1; i < path.size() - 1; ++i) {
            Predicate.PathElement element = path.get(i);
            sb.append(".");
            sb.append(element.getFieldName());
        }
        return sb.toString();
    }

    public Criterion apply(Predicate predicate) {
        String alias;
        List path = predicate.getPath();
        if (path.size() > 1) {
            alias = CriterionFilterOperation.getAlias(path);
            alias = alias + "." + ((Predicate.PathElement)path.get(path.size() - 1)).getFieldName();
        } else {
            alias = ((Predicate.PathElement)path.get(0)).getFieldName();
        }
        switch (predicate.getOperator()) {
            case IN: {
                if (predicate.getValues().isEmpty()) {
                    return Restrictions.sqlRestriction((String)"(false)");
                }
                return Restrictions.in((String)alias, (Collection)predicate.getValues());
            }
            case NOT: {
                if (predicate.getValues().isEmpty()) {
                    return Restrictions.sqlRestriction((String)"(true)");
                }
                return Restrictions.not((Criterion)Restrictions.in((String)alias, (Collection)predicate.getValues()));
            }
            case PREFIX: {
                return Restrictions.like((String)alias, (Object)(predicate.getValues().get(0) + "%"));
            }
            case POSTFIX: {
                return Restrictions.like((String)alias, (Object)("%" + predicate.getValues().get(0)));
            }
            case INFIX: {
                return Restrictions.like((String)alias, (Object)("%" + predicate.getValues().get(0) + "%"));
            }
            case ISNULL: {
                return Restrictions.isNull((String)alias);
            }
            case NOTNULL: {
                return Restrictions.isNotNull((String)alias);
            }
            case LT: {
                return Restrictions.lt((String)alias, predicate.getValues().get(0));
            }
            case LE: {
                return Restrictions.le((String)alias, predicate.getValues().get(0));
            }
            case GT: {
                return Restrictions.gt((String)alias, predicate.getValues().get(0));
            }
            case GE: {
                return Restrictions.ge((String)alias, predicate.getValues().get(0));
            }
            case TRUE: {
                return Restrictions.sqlRestriction((String)"(true)");
            }
            case FALSE: {
                return Restrictions.sqlRestriction((String)"(false)");
            }
        }
        throw new InvalidPredicateException("Operator not implemented: " + predicate.getOperator());
    }

    public Criterion applyAll(Set<Predicate> predicates) {
        Criterion result = null;
        for (Predicate predicate : predicates) {
            if (result == null) {
                result = this.apply(predicate);
            }
            result = Restrictions.and((Criterion)result, (Criterion)this.apply(predicate));
        }
        return result;
    }

    public Criteria apply(FilterExpression filterExpression) {
        CriteriaVisitor visitor = new CriteriaVisitor();
        Criterion restrictions = (Criterion)filterExpression.accept((Visitor)visitor);
        HashSet<String> createdAliases = new HashSet<String>();
        for (Predicate predicate : visitor.getPredicates()) {
            List path = predicate.getPath();
            if (path.size() < 2) continue;
            List<Object> copy = new ArrayList<Predicate.PathElement>(path);
            while (copy.size() > 1) {
                String alias = CriterionFilterOperation.getAlias(copy);
                String associationPath = CriterionFilterOperation.getAssociationPath(copy);
                if (!createdAliases.contains(alias)) {
                    this.criteria.createAlias(associationPath, alias);
                    createdAliases.add(alias);
                }
                copy = copy.subList(0, copy.size() - 1);
            }
        }
        this.criteria.add(restrictions);
        return this.criteria;
    }

    public class CriteriaVisitor
    implements Visitor<Criterion> {
        private Criterion criterion;
        private final Set<Predicate> predicates = new HashSet<Predicate>();

        public Criterion visitPredicate(Predicate predicate) {
            this.predicates.add(predicate);
            this.criterion = CriterionFilterOperation.this.apply(predicate);
            return this.criterion;
        }

        public Criterion visitAndExpression(AndFilterExpression expression) {
            Criterion left = (Criterion)expression.getLeft().accept((Visitor)this);
            Criterion right = (Criterion)expression.getRight().accept((Visitor)this);
            this.criterion = Restrictions.and((Criterion)left, (Criterion)right);
            return this.criterion;
        }

        public Criterion visitOrExpression(OrFilterExpression expression) {
            Criterion left = (Criterion)expression.getLeft().accept((Visitor)this);
            Criterion right = (Criterion)expression.getRight().accept((Visitor)this);
            this.criterion = Restrictions.or((Criterion)left, (Criterion)right);
            return this.criterion;
        }

        public Criterion visitNotExpression(NotFilterExpression expression) {
            Criterion negated = (Criterion)expression.getNegated().accept((Visitor)this);
            this.criterion = Restrictions.not((Criterion)negated);
            return this.criterion;
        }

        public Set<Predicate> getPredicates() {
            return this.predicates;
        }
    }
}

