/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate3;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RelationshipImpl;
import com.yahoo.elide.core.hibernate.hql.RootCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RootCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.datastores.hibernate3.ScrollableIterator;
import com.yahoo.elide.datastores.hibernate3.porting.QueryWrapper;
import com.yahoo.elide.datastores.hibernate3.porting.SessionWrapper;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.ScrollMode;
import org.hibernate.collection.AbstractPersistentCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTransaction
implements DataStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(HibernateTransaction.class);
    private final org.hibernate.Session session;
    private final SessionWrapper sessionWrapper;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final boolean isScrollEnabled;
    private final ScrollMode scrollMode;

    protected HibernateTransaction(org.hibernate.Session session, boolean isScrollEnabled, ScrollMode scrollMode) {
        this.session = session;
        this.sessionWrapper = new SessionWrapper(session);
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
    }

    public void delete(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.delete(object));
    }

    public void save(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.saveOrUpdate(object));
    }

    public void flush(RequestScope requestScope) {
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            FlushMode flushMode = this.session.getFlushMode();
            if (flushMode != FlushMode.COMMIT && flushMode != FlushMode.MANUAL && flushMode != FlushMode.NEVER) {
                this.session.flush();
            }
        }
        catch (HibernateException e) {
            log.error("Caught hibernate exception during flush", (Throwable)e);
            throw new TransactionException((Throwable)e);
        }
    }

    public void commit(RequestScope scope) {
        try {
            this.flush(scope);
            this.session.getTransaction().commit();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void createObject(Object entity, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.persist(entity));
    }

    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        try {
            EntityDictionary dictionary = scope.getDictionary();
            Class idType = dictionary.getIdType(entityClass);
            String idField = dictionary.getIdFieldName(entityClass);
            Path.PathElement idPath = new Path.PathElement(entityClass, idType, idField);
            FilterPredicate idExpression = id != null ? new FilterPredicate(idPath, Operator.IN, Collections.singletonList(id)) : new FilterPredicate(idPath, Operator.FALSE, Collections.emptyList());
            FilterExpression joinedExpression = filterExpression.map(fe -> new AndFilterExpression(fe, (FilterExpression)idExpression)).orElse((FilterExpression)idExpression);
            QueryWrapper query = (QueryWrapper)new RootCollectionFetchQueryBuilder(entityClass, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(Optional.of(joinedExpression)).build();
            return query.getQuery().uniqueResult();
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public Iterable<Object> loadObjects(Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        pagination.ifPresent(p -> {
            if (p.isGenerateTotals()) {
                p.setPageTotals(this.getTotalRecords(entityClass, filterExpression, scope.getDictionary()).longValue());
            }
        });
        QueryWrapper query = (QueryWrapper)new RootCollectionFetchQueryBuilder(entityClass, scope.getDictionary(), (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
        if (this.isScrollEnabled) {
            return new ScrollableIterator<Object>(query.getQuery().scroll());
        }
        return query.getQuery().list();
    }

    public Object getRelation(DataStoreTransaction relationTx, Object entity, String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        Collection filteredVal;
        EntityDictionary dictionary = scope.getDictionary();
        Object val = PersistentResource.getValue((Object)entity, (String)relationName, (RequestScope)scope);
        if (val instanceof Collection && (filteredVal = (Collection)val) instanceof AbstractPersistentCollection) {
            Class relationClass = dictionary.getParameterizedType(entity, relationName);
            RelationshipImpl relationship = new RelationshipImpl(entity.getClass(), relationClass, relationName, entity, filteredVal);
            pagination.ifPresent(p -> {
                if (p.isGenerateTotals()) {
                    p.setPageTotals(this.getTotalRecords((AbstractHQLQueryBuilder.Relationship)relationship, filterExpression, dictionary).longValue());
                }
            });
            QueryWrapper query = (QueryWrapper)new SubCollectionFetchQueryBuilder((AbstractHQLQueryBuilder.Relationship)relationship, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
            if (query != null) {
                return query.getQuery().list();
            }
        }
        return val;
    }

    private <T> Long getTotalRecords(Class<T> entityClass, Optional<FilterExpression> filterExpression, EntityDictionary dictionary) {
        QueryWrapper query = (QueryWrapper)new RootCollectionPageTotalsQueryBuilder(entityClass, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).build();
        return (Long)query.getQuery().uniqueResult();
    }

    private <T> Long getTotalRecords(AbstractHQLQueryBuilder.Relationship relationship, Optional<FilterExpression> filterExpression, EntityDictionary dictionary) {
        QueryWrapper query = (QueryWrapper)new SubCollectionPageTotalsQueryBuilder(relationship, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).build();
        return (Long)query.getQuery().uniqueResult();
    }

    public void close() throws IOException {
        if (this.session.isOpen() && this.session.getTransaction().isActive()) {
            this.session.getTransaction().rollback();
            throw new IOException("Transaction not closed");
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }

    public Integer getQueryLimit() {
        return null;
    }

    private static String getRandomAlias(Class<?> entityType) {
        return EntityDictionary.getSimpleName(entityType) + ThreadLocalRandom.current().nextInt(1, 1000);
    }
}

