/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.FilterScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.datastores.hibernate5.HQLTransaction;
import com.yahoo.elide.datastores.hibernate5.ScrollableIterator;
import com.yahoo.elide.datastores.hibernate5.filter.CriteriaExplorer;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class HibernateTransaction
implements DataStoreTransaction {
    private static final Function<Criterion, Criterion> NOT = Restrictions::not;
    private static final BiFunction<Criterion, Criterion, Criterion> AND = Restrictions::and;
    private static final BiFunction<Criterion, Criterion, Criterion> OR = Restrictions::or;
    private final Session session;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final boolean isScrollEnabled;
    private final ScrollMode scrollMode;

    @Deprecated
    public HibernateTransaction(Session session) {
        this.session = session;
        this.isScrollEnabled = true;
        this.scrollMode = ScrollMode.FORWARD_ONLY;
    }

    protected HibernateTransaction(Session session, boolean isScrollEnabled, ScrollMode scrollMode) {
        this.session = session;
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
    }

    public void delete(Object object) {
        this.deferredTasks.add(() -> this.session.delete(object));
    }

    public void save(Object object) {
        this.deferredTasks.add(() -> this.session.saveOrUpdate(object));
    }

    public void flush() {
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            this.session.flush();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void commit() {
        try {
            this.flush();
            this.session.getTransaction().commit();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public <T> T createObject(Class<T> entityClass) {
        try {
            Object object = entityClass.newInstance();
            this.deferredTasks.add(() -> this.session.persist(object));
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public <T> T loadObject(Class<T> loadClass, Serializable id) {
        try {
            Object record = this.session.load(loadClass, id);
            Hibernate.initialize((Object)record);
            return (T)record;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass) {
        Criteria sessionCriteria = this.session.createCriteria(loadClass);
        if (this.isScrollEnabled) {
            return new ScrollableIterator(sessionCriteria.scroll(this.scrollMode));
        }
        return sessionCriteria.list();
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass, FilterScope filterScope) {
        Criterion criterion = (Criterion)filterScope.getCriterion(NOT, AND, OR);
        CriteriaExplorer criteriaExplorer = new CriteriaExplorer(loadClass, filterScope.getRequestScope(), criterion);
        return this.loadObjects(loadClass, criteriaExplorer, Optional.empty(), Optional.empty());
    }

    public <T> Iterable<T> loadObjectsWithSortingAndPagination(Class<T> entityClass, FilterScope filterScope) {
        Criterion criterion = (Criterion)filterScope.getCriterion(NOT, AND, OR);
        Pagination pagination = filterScope.hasPagination() ? filterScope.getRequestScope().getPagination() : null;
        Set validatedSortingRules = null;
        if (filterScope.hasSortingRules()) {
            Sorting sorting = filterScope.getRequestScope().getSorting();
            EntityDictionary dictionary = filterScope.getRequestScope().getDictionary();
            validatedSortingRules = sorting.getValidSortingRules(entityClass, dictionary).entrySet().stream().map(entry -> ((Sorting.SortOrder)entry.getValue()).equals((Object)Sorting.SortOrder.desc) ? Order.desc((String)((String)entry.getKey())) : Order.asc((String)((String)entry.getKey()))).collect(Collectors.toSet());
        }
        return this.loadObjects(entityClass, new CriteriaExplorer(entityClass, filterScope.getRequestScope(), criterion), Optional.ofNullable(validatedSortingRules), Optional.ofNullable(pagination));
    }

    public <T> Iterable<T> loadObjects(Class<T> loadClass, CriteriaExplorer criteriaExplorer, Optional<Set<Order>> sortingRules, Optional<Pagination> pagination) {
        Criteria sessionCriteria = this.session.createCriteria(loadClass);
        criteriaExplorer.buildCriteria(sessionCriteria, this.session);
        if (sortingRules.isPresent()) {
            sortingRules.get().forEach(arg_0 -> ((Criteria)sessionCriteria).addOrder(arg_0));
        }
        if (pagination.isPresent()) {
            Pagination paginationData = pagination.get();
            sessionCriteria.setFirstResult(paginationData.getOffset());
            sessionCriteria.setMaxResults(paginationData.getLimit());
        }
        if (this.isScrollEnabled) {
            return new ScrollableIterator(sessionCriteria.scroll(this.scrollMode));
        }
        return sessionCriteria.list();
    }

    public <T> Collection filterCollection(Collection collection, Class<T> entityClass, Set<Predicate> predicates) {
        String filterString;
        if (collection instanceof AbstractPersistentCollection && !predicates.isEmpty() && (filterString = new HQLFilterOperation().applyAll(predicates)).length() != 0) {
            Query query = this.session.createFilter((Object)collection, filterString);
            for (Predicate predicate : predicates) {
                if (!predicate.getOperator().isParameterized()) continue;
                query = query.setParameterList(predicate.getField(), (Collection)predicate.getValues());
            }
            return query.list();
        }
        return collection;
    }

    public <T> Collection filterCollectionWithSortingAndPagination(Collection collection, Class<T> entityClass, EntityDictionary dictionary, Optional<Set<Predicate>> filters, Optional<Sorting> sorting, Optional<Pagination> pagination) {
        Optional<Query> possibleQuery;
        if (collection instanceof AbstractPersistentCollection && (filters.isPresent() || sorting.isPresent() || pagination.isPresent()) && (possibleQuery = new HQLTransaction.Builder<T>(this.session, collection, entityClass, dictionary).withPossibleFilters(filters).withPossibleSorting(sorting).withPossiblePagination(pagination).build()).isPresent()) {
            return possibleQuery.get().list();
        }
        return collection;
    }

    public void close() throws IOException {
        if (this.session.isOpen() && this.session.getTransaction().getStatus() == TransactionStatus.ACTIVE) {
            this.session.getTransaction().rollback();
            throw new IOException("Transaction not closed");
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }
}

