/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.datastores.hibernate5.PersistenceTransaction;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EntityType;

public class PersistenceStore
implements DataStore {
    private final EntityManagerFactory entityManagerFactory;

    public PersistenceStore(EntityManagerFactory entityManagerFactory) {
        Preconditions.checkNotNull((Object)entityManagerFactory);
        this.entityManagerFactory = entityManagerFactory;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (EntityType entity : this.entityManagerFactory.getMetamodel().getEntities()) {
            dictionary.bindEntity(entity.getBindableJavaType());
        }
    }

    public DataStoreTransaction beginTransaction() {
        return new PersistenceTransaction(this.entityManagerFactory.createEntityManager());
    }
}

