/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import javax.persistence.EntityManager;

public class PersistenceTransaction
implements DataStoreTransaction {
    private final EntityManager entityManager;

    public PersistenceTransaction(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.entityManager.getTransaction().begin();
    }

    public void save(Object entity) {
        this.entityManager.persist(entity);
    }

    public void delete(Object entity) {
        this.entityManager.remove(entity);
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void commit() {
        this.flush();
        this.entityManager.getTransaction().commit();
    }

    public <T> T createObject(Class<T> entityClass) {
        try {
            T entity = entityClass.newInstance();
            this.entityManager.persist(entity);
            return entity;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public <T> T loadObject(Class<T> entityClass, Serializable id) {
        return (T)this.entityManager.find(entityClass, (Object)id);
    }

    public <T> Iterable<T> loadObjects(Class<T> entityClass) {
        return this.entityManager.createQuery("from " + entityClass.getName(), entityClass).getResultList();
    }

    public void close() throws IOException {
        try {
            if (this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().rollback();
                throw new IOException("Transaction not closed");
            }
        }
        finally {
            this.entityManager.close();
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }
}

