/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import lombok.NonNull;
import org.hibernate.ScrollableResults;

public class ScrollableIterator<T>
implements Iterable<T>,
Iterator<T> {
    private final ScrollableResults scroll;
    private boolean inUse = false;
    private boolean hasNext;

    public ScrollableIterator(ScrollableResults scroll) {
        this.scroll = scroll;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.inUse) {
            throw new ConcurrentModificationException();
        }
        if (!this.scroll.first()) {
            return Collections.emptyListIterator();
        }
        this.inUse = true;
        this.hasNext = true;
        return Iterators.unmodifiableIterator((Iterator)this);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NonNull
    public T next() {
        Object row = this.scroll.get()[0];
        Preconditions.checkNotNull((Object)row);
        this.hasNext = this.scroll.next();
        return (T)row;
    }
}

