/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5.filter;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.datastores.hibernate5.filter.CriterionFilterOperation;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;

public class CriteriaExplorer {
    private final Criterion rootCriterion;
    private final CriterionFilterOperation filterOperation = new CriterionFilterOperation();
    private final RequestScope requestScope;
    private final EntityDictionary dictionary;
    private final Class<?> loadClass;

    public CriteriaExplorer(Class<?> loadClass, RequestScope requestScope, Criterion existing) {
        this.requestScope = requestScope;
        this.dictionary = requestScope.getDictionary();
        this.rootCriterion = this.buildRootCriterion(loadClass, existing);
        this.loadClass = loadClass;
    }

    public void buildCriteria(Criteria sessionCriteria, Session session) {
        if (this.rootCriterion != null) {
            sessionCriteria.add(this.rootCriterion);
        }
        for (Map.Entry entry : this.requestScope.getPredicates().entrySet()) {
            String criteriaPath = (String)entry.getKey();
            Set predicates = (Set)entry.getValue();
            String[] objects = criteriaPath.split("\\.");
            Class filterClass = this.dictionary.getEntityClass(objects[0]);
            Criteria criteria = this.loadClass.equals(filterClass) ? sessionCriteria : session.createCriteria(filterClass);
            for (int i = 1; i < objects.length; ++i) {
                criteria = criteria.createCriteria(objects[i]);
            }
            criteria.add(this.filterOperation.applyAll((Set<Predicate>)predicates));
        }
    }

    private Criterion buildRootCriterion(Class<?> loadClass, Criterion existing) {
        String type = this.dictionary.getJsonAliasFor(loadClass);
        return CriterionFilterOperation.andWithNull(existing, this.filterOperation.applyAll((Set<Predicate>)this.requestScope.getPredicatesOfType(type)));
    }
}

