/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.expression.Visitor;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;

public class HQLTransaction {

    public static class Builder<T> {
        private final Session session;
        private final Collection collection;
        private final Class<T> entityClass;
        private final EntityDictionary dictionary;
        private Set<FilterPredicate> filters = null;
        private String sortingRules;
        private Pagination pagination = null;
        private FilterExpression filterExpression = null;

        public Builder(Session session, Collection collection, Class<T> entityClass, EntityDictionary dictionary) {
            this.session = session;
            this.collection = collection;
            this.entityClass = entityClass;
            this.dictionary = dictionary;
        }

        public Builder withPossibleFilterExpression(Optional<FilterExpression> filterExpression) {
            return filterExpression.map(this::withFilterExpression).orElse(this);
        }

        public Builder withFilterExpression(FilterExpression filterExpression) {
            this.filterExpression = filterExpression;
            PredicateExtractionVisitor visitor = new PredicateExtractionVisitor();
            this.filters = (Set)filterExpression.accept((Visitor)visitor);
            return this;
        }

        public Builder withPossibleFilters(Optional<Set<FilterPredicate>> possibleFilters) {
            return possibleFilters.map(this::withFilters).orElse(this);
        }

        public Builder withFilters(Set<FilterPredicate> filters) {
            if (filters != null && !filters.isEmpty()) {
                this.filters = filters;
            }
            return this;
        }

        public Builder withPossibleSorting(Optional<Sorting> possibleSorting) {
            return possibleSorting.map(this::withSorting).orElse(this);
        }

        public Builder withSorting(Sorting sorting) {
            Map validSortingRules;
            if (sorting != null && !sorting.isDefaultInstance() && !(validSortingRules = sorting.getValidSortingRules(this.entityClass, this.dictionary)).isEmpty()) {
                ArrayList ordering = new ArrayList();
                validSortingRules.entrySet().stream().forEachOrdered(entry -> ordering.add((String)entry.getKey() + " " + (((Sorting.SortOrder)entry.getValue()).equals((Object)Sorting.SortOrder.desc) ? "desc" : "asc")));
                this.sortingRules = " order by " + StringUtils.join(ordering, (String)",");
            }
            return this;
        }

        public Builder withPossiblePagination(Optional<Pagination> possiblePagination) {
            return possiblePagination.map(this::withPagination).orElse(this);
        }

        public Builder withPagination(Pagination pagination) {
            if (pagination != null) {
                this.pagination = pagination;
            }
            return this;
        }

        public Optional<Query> build() {
            String filterString = "";
            if (this.filterExpression != null) {
                filterString = filterString + new HQLFilterOperation().apply(this.filterExpression);
            } else if (this.filters != null) {
                filterString = filterString + new HQLFilterOperation().applyAll(this.filters);
            }
            if (!StringUtils.isEmpty((CharSequence)this.sortingRules)) {
                filterString = filterString + this.sortingRules;
            }
            Query query = null;
            if (filterString.length() != 0) {
                query = this.session.createFilter((Object)this.collection, filterString);
                if (this.filters != null) {
                    for (FilterPredicate filterPredicate : this.filters) {
                        if (!filterPredicate.getOperator().isParameterized()) continue;
                        String name = filterPredicate.getParameterName();
                        query = query.setParameterList(name, (Collection)filterPredicate.getValues());
                    }
                }
            }
            if (this.pagination != null) {
                if (query == null) {
                    query = this.session.createFilter((Object)this.collection, "");
                }
                query.setFirstResult(this.pagination.getOffset());
                query.setMaxResults(this.pagination.getLimit());
            }
            return Optional.ofNullable(query);
        }
    }
}

