/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.datastores.hibernate5.HibernateStore;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.jpa.HibernateEntityManager;
import org.hibernate.metadata.ClassMetadata;

public class HibernateEntityManagerStore
extends HibernateStore {
    protected final HibernateEntityManager entityManager;

    public HibernateEntityManagerStore(HibernateEntityManager entityManager, boolean isScrollEnabled, ScrollMode scrollMode) {
        super(null, isScrollEnabled, scrollMode);
        this.entityManager = entityManager;
    }

    @Override
    public Session getSession() {
        return this.entityManager.getSession();
    }

    @Override
    public DataStoreTransaction beginTransaction() {
        Session session = this.getSession();
        session.beginTransaction();
        session.clear();
        return this.transactionSupplier.get(session, this.isScrollEnabled, this.scrollMode);
    }

    @Override
    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (ClassMetadata meta : this.getSession().getSessionFactory().getAllClassMetadata().values()) {
            dictionary.bindEntity(meta.getMappedClass());
        }
    }
}

