/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.datastores.hibernate5.HibernateEntityManagerStore;
import com.yahoo.elide.datastores.hibernate5.HibernateSessionFactoryStore;
import com.yahoo.elide.datastores.hibernate5.HibernateTransaction;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jpa.HibernateEntityManager;
import org.hibernate.metadata.ClassMetadata;

public class HibernateStore
implements DataStore {
    protected final SessionFactory sessionFactory;
    protected final boolean isScrollEnabled;
    protected final ScrollMode scrollMode;
    protected final HibernateTransactionSupplier transactionSupplier;

    protected HibernateStore(SessionFactory aSessionFactory, boolean isScrollEnabled, ScrollMode scrollMode) {
        this(aSessionFactory, isScrollEnabled, scrollMode, HibernateTransaction::new);
    }

    protected HibernateStore(SessionFactory aSessionFactory, boolean isScrollEnabled, ScrollMode scrollMode, HibernateTransactionSupplier transactionSupplier) {
        this.sessionFactory = aSessionFactory;
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
        this.transactionSupplier = transactionSupplier;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (ClassMetadata meta : this.sessionFactory.getAllClassMetadata().values()) {
            dictionary.bindEntity(meta.getMappedClass());
        }
    }

    @Deprecated
    public Session getSession() {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Preconditions.checkNotNull((Object)session);
            Preconditions.checkArgument((boolean)session.isConnected());
            return session;
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Deprecated
    public DataStoreTransaction beginTransaction() {
        Session session = this.sessionFactory.getCurrentSession();
        Preconditions.checkNotNull((Object)session);
        session.beginTransaction();
        return this.transactionSupplier.get(session, this.isScrollEnabled, this.scrollMode);
    }

    @FunctionalInterface
    public static interface HibernateTransactionSupplier {
        public HibernateTransaction get(Session var1, boolean var2, ScrollMode var3);
    }

    public static class Builder {
        private final SessionFactory sessionFactory;
        private final HibernateEntityManager entityManager;
        private boolean isScrollEnabled;
        private ScrollMode scrollMode;

        public Builder(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.isScrollEnabled = true;
            this.scrollMode = ScrollMode.FORWARD_ONLY;
            this.entityManager = null;
        }

        public Builder(HibernateEntityManager entityManager) {
            this.sessionFactory = null;
            this.isScrollEnabled = true;
            this.scrollMode = ScrollMode.FORWARD_ONLY;
            this.entityManager = entityManager;
        }

        public Builder withScrollEnabled(boolean isScrollEnabled) {
            this.isScrollEnabled = isScrollEnabled;
            return this;
        }

        public Builder withScrollMode(ScrollMode scrollMode) {
            this.scrollMode = scrollMode;
            return this;
        }

        public HibernateStore build() {
            if (this.sessionFactory != null) {
                return new HibernateSessionFactoryStore(this.sessionFactory, this.isScrollEnabled, this.scrollMode);
            }
            if (this.entityManager != null) {
                return new HibernateEntityManagerStore(this.entityManager, this.isScrollEnabled, this.scrollMode);
            }
            throw new IllegalStateException("Either an EntityManager or SessionFactory is required!");
        }
    }
}

