/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.HQLFilterOperation;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.InMemoryFilterVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.expression.Visitor;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.datastores.hibernate5.HQLTransaction;
import com.yahoo.elide.datastores.hibernate5.ScrollableIterator;
import com.yahoo.elide.datastores.hibernate5.filter.CriterionFilterOperation;
import com.yahoo.elide.extensions.PatchRequestScope;
import com.yahoo.elide.security.User;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class HibernateTransaction
implements DataStoreTransaction {
    private final Session session;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final boolean isScrollEnabled;
    private final ScrollMode scrollMode;

    protected HibernateTransaction(Session session, boolean isScrollEnabled, ScrollMode scrollMode) {
        this.session = session;
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
    }

    public void delete(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.delete(object));
    }

    public void save(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.saveOrUpdate(object));
    }

    public void flush(RequestScope requestScope) {
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            FlushMode flushMode = this.session.getFlushMode();
            if (flushMode != FlushMode.COMMIT && flushMode != FlushMode.MANUAL && flushMode != FlushMode.NEVER) {
                this.session.flush();
            }
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void commit(RequestScope scope) {
        try {
            this.flush(scope);
            this.session.getTransaction().commit();
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void createObject(Object entity, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.persist(entity));
    }

    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        try {
            Criteria criteria = this.session.createCriteria(entityClass).add(Restrictions.idEq((Object)id));
            criteria.setFlushMode(FlushMode.MANUAL);
            if (filterExpression.isPresent()) {
                CriterionFilterOperation filterOpn = this.buildCriterionFilterOperation(criteria);
                criteria = filterOpn.apply(filterExpression.get());
            }
            return criteria.uniqueResult();
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    protected CriterionFilterOperation buildCriterionFilterOperation(Criteria criteria) {
        return new CriterionFilterOperation(criteria);
    }

    public Iterable<Object> loadObjects(Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        pagination.ifPresent(p -> {
            if (p.isGenerateTotals()) {
                p.setPageTotals(this.getTotalRecords(entityClass, filterExpression).longValue());
            }
        });
        Criteria criteria = this.session.createCriteria(entityClass);
        if (filterExpression.isPresent()) {
            CriterionFilterOperation filterOpn = this.buildCriterionFilterOperation(criteria);
            criteria = filterOpn.apply(filterExpression.get());
        }
        Set validatedSortingRules = null;
        if (sorting.isPresent() && !sorting.get().isDefaultInstance()) {
            EntityDictionary dictionary = scope.getDictionary();
            validatedSortingRules = sorting.get().getValidSortingRules(entityClass, dictionary).entrySet().stream().map(entry -> ((Sorting.SortOrder)entry.getValue()).equals((Object)Sorting.SortOrder.desc) ? Order.desc((String)((String)entry.getKey())) : Order.asc((String)((String)entry.getKey()))).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.loadObjects(entityClass, criteria, Optional.ofNullable(validatedSortingRules), pagination);
    }

    public Iterable loadObjects(Class<?> loadClass, Criteria criteria, Optional<Set<Order>> sortingRules, Optional<Pagination> pagination) {
        if (sortingRules.isPresent()) {
            sortingRules.get().forEach(arg_0 -> ((Criteria)criteria).addOrder(arg_0));
        }
        if (pagination.isPresent()) {
            Pagination paginationData = pagination.get();
            criteria.setFirstResult(paginationData.getOffset());
            criteria.setMaxResults(paginationData.getLimit());
        }
        if (this.isScrollEnabled) {
            return new ScrollableIterator(criteria.scroll(this.scrollMode));
        }
        return criteria.list();
    }

    public Object getRelation(DataStoreTransaction relationTx, Object entity, String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        Collection filteredVal;
        EntityDictionary dictionary = scope.getDictionary();
        Object val = PersistentResource.getValue((Object)entity, (String)relationName, (RequestScope)scope);
        if (val instanceof Collection && (filteredVal = (Collection)val) instanceof AbstractPersistentCollection) {
            if (scope instanceof PatchRequestScope && filterExpression.isPresent()) {
                Class relationClass = dictionary.getType(entity, relationName);
                return this.patchRequestFilterCollection(filteredVal, relationClass, filterExpression.get(), (RequestScope)((PatchRequestScope)scope));
            }
            Class relationClass = dictionary.getParameterizedType(entity, relationName);
            pagination.ifPresent(p -> {
                if (p.isGenerateTotals()) {
                    p.setPageTotals(this.getTotalRecords(entity, filterExpression, relationName, dictionary).longValue());
                }
            });
            Optional<Query> possibleQuery = new HQLTransaction.Builder(this.session, filteredVal, relationClass, dictionary).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
            if (possibleQuery.isPresent()) {
                return possibleQuery.get().list();
            }
        }
        return val;
    }

    private <T> Long getTotalRecords(Class<T> entityClass, Optional<FilterExpression> filterExpression) {
        String queryString = "SELECT COUNT(*) FROM {parentType} {parentType}";
        queryString = queryString.replaceAll("\\{parentType\\}", entityClass.getSimpleName());
        Query query = filterExpression.isPresent() ? this.populateWhereClause(queryString, filterExpression.get()) : this.session.createQuery(queryString);
        return (Long)query.uniqueResult();
    }

    private <T> Long getTotalRecords(Object entity, Optional<FilterExpression> filterExpression, String relation, EntityDictionary dictionary) {
        Class<?> entityType = entity.getClass();
        Class idType = dictionary.getIdType(entityType);
        Object idVal = CoerceUtil.coerce((Object)dictionary.getId(entity), (Class)idType);
        String idField = dictionary.getIdFieldName(entityType);
        String parentTypeAlias = HibernateTransaction.getRandomAlias(entityType);
        FilterPredicate idExpression = new FilterPredicate(new FilterPredicate.PathElement(entityType, entityType.getSimpleName(), idType, idField), Operator.IN, Collections.singletonList(idVal));
        idExpression.setAlias(parentTypeAlias);
        FilterPredicate joinedExpression = idExpression;
        if (filterExpression.isPresent()) {
            joinedExpression = new AndFilterExpression(filterExpression.get(), (FilterExpression)idExpression);
        }
        Class relationClass = dictionary.getParameterizedType(entityType, relation);
        String queryString = "SELECT COUNT(*) FROM {parentType} {parentTypeAlias} join {parentTypeAlias}.{relation} {relationType}";
        queryString = queryString.replaceAll("\\{parentType\\}", entityType.getSimpleName());
        queryString = queryString.replaceAll("\\{parentTypeAlias\\}", parentTypeAlias);
        queryString = queryString.replaceAll("\\{relation\\}", relation);
        queryString = queryString.replaceAll("\\{relationType\\}", relationClass.getSimpleName());
        Query query = this.populateWhereClause(queryString, (FilterExpression)joinedExpression);
        return (Long)query.uniqueResult();
    }

    private Query populateWhereClause(String hqlQuery, FilterExpression expression) {
        String completeQuery = hqlQuery + " " + new HQLFilterOperation().apply(expression, true);
        Query query = this.session.createQuery(completeQuery);
        PredicateExtractionVisitor visitor = new PredicateExtractionVisitor();
        Set predicates = (Set)expression.accept((Visitor)visitor);
        for (FilterPredicate filterPredicate : predicates) {
            if (!filterPredicate.getOperator().isParameterized()) continue;
            String name = filterPredicate.getParameterName();
            if (filterPredicate.isMatchingOperator()) {
                query = query.setParameter(name, (Object)filterPredicate.getStringValueEscaped("%", "\\"));
                continue;
            }
            query = query.setParameterList(name, (Collection)filterPredicate.getValues());
        }
        return query;
    }

    protected <T> Collection patchRequestFilterCollection(Collection collection, Class<T> entityClass, FilterExpression filterExpression, RequestScope requestScope) {
        InMemoryFilterVisitor inMemoryFilterVisitor = new InMemoryFilterVisitor(requestScope);
        Predicate inMemoryFilterFn = (Predicate)filterExpression.accept((Visitor)inMemoryFilterVisitor);
        return collection.stream().filter(e -> inMemoryFilterFn.test(e)).collect(Collectors.toList());
    }

    public void close() throws IOException {
        if (this.session.isOpen() && this.session.getTransaction().getStatus() == TransactionStatus.ACTIVE) {
            this.session.getTransaction().rollback();
            throw new IOException("Transaction not closed");
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }

    private static String getRandomAlias(Class<?> entityType) {
        return entityType.getSimpleName() + ThreadLocalRandom.current().nextInt(1, 1000);
    }
}

