/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.datastores.hibernate5.AbstractHibernateStore;
import javax.persistence.PersistenceException;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateSessionFactoryStore
extends AbstractHibernateStore {
    public HibernateSessionFactoryStore(SessionFactory aSessionFactory, boolean isScrollEnabled, ScrollMode scrollMode) {
        super(aSessionFactory, isScrollEnabled, scrollMode);
    }

    @Override
    public Session getSession() {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Preconditions.checkNotNull((Object)session);
            Preconditions.checkArgument((boolean)session.isConnected());
            return session;
        }
        catch (PersistenceException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public DataStoreTransaction beginTransaction() {
        Session session = this.sessionFactory.getCurrentSession();
        Preconditions.checkNotNull((Object)session);
        session.beginTransaction();
        return this.transactionSupplier.get(session, this.isScrollEnabled, this.scrollMode);
    }
}

