/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.datastore.JPQLDataStore;
import com.yahoo.elide.datastores.hibernate5.HibernateEntityManagerStore;
import com.yahoo.elide.datastores.hibernate5.HibernateSessionFactoryStore;
import com.yahoo.elide.datastores.hibernate5.HibernateTransaction;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jpa.HibernateEntityManager;

public abstract class AbstractHibernateStore
implements JPQLDataStore {
    protected final SessionFactory sessionFactory;
    protected final boolean isScrollEnabled;
    protected final ScrollMode scrollMode;
    protected final HibernateTransactionSupplier transactionSupplier;

    protected AbstractHibernateStore(SessionFactory aSessionFactory, boolean isScrollEnabled, ScrollMode scrollMode) {
        this(aSessionFactory, isScrollEnabled, scrollMode, HibernateTransaction::new);
    }

    protected AbstractHibernateStore(SessionFactory aSessionFactory, boolean isScrollEnabled, ScrollMode scrollMode, HibernateTransactionSupplier transactionSupplier) {
        this.sessionFactory = aSessionFactory;
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
        this.transactionSupplier = transactionSupplier;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (EntityType type : this.sessionFactory.getMetamodel().getEntities()) {
            this.bindEntity(dictionary, type);
        }
    }

    protected void bindEntity(EntityDictionary dictionary, EntityType type) {
        Class mappedClass = type.getJavaType();
        this.bindEntityClass(mappedClass, dictionary);
    }

    public abstract Session getSession();

    public abstract DataStoreTransaction beginTransaction();

    @FunctionalInterface
    public static interface HibernateTransactionSupplier {
        public HibernateTransaction get(Session var1, boolean var2, ScrollMode var3);
    }

    public static class Builder {
        private final SessionFactory sessionFactory;
        private final EntityManager entityManager;
        private boolean isScrollEnabled;
        private ScrollMode scrollMode;

        public Builder(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.isScrollEnabled = true;
            this.scrollMode = ScrollMode.FORWARD_ONLY;
            this.entityManager = null;
        }

        public Builder(EntityManager entityManager) {
            this.sessionFactory = null;
            this.isScrollEnabled = true;
            this.scrollMode = ScrollMode.FORWARD_ONLY;
            this.entityManager = entityManager;
        }

        @Deprecated
        public Builder(HibernateEntityManager entityManager) {
            this.sessionFactory = null;
            this.isScrollEnabled = true;
            this.scrollMode = ScrollMode.FORWARD_ONLY;
            this.entityManager = entityManager;
        }

        public Builder withScrollEnabled(boolean isScrollEnabled) {
            this.isScrollEnabled = isScrollEnabled;
            return this;
        }

        public Builder withScrollMode(ScrollMode scrollMode) {
            this.scrollMode = scrollMode;
            return this;
        }

        public AbstractHibernateStore build() {
            if (this.sessionFactory != null) {
                return new HibernateSessionFactoryStore(this.sessionFactory, this.isScrollEnabled, this.scrollMode);
            }
            if (this.entityManager != null) {
                return new HibernateEntityManagerStore(this.entityManager, this.isScrollEnabled, this.scrollMode);
            }
            throw new IllegalStateException("Either an EntityManager or SessionFactory is required!");
        }
    }
}

