/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate5;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.FalsePredicate;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.InPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RelationshipImpl;
import com.yahoo.elide.core.hibernate.hql.RootCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RootCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.datastores.hibernate5.ScrollableIterator;
import com.yahoo.elide.datastores.hibernate5.porting.QueryWrapper;
import com.yahoo.elide.datastores.hibernate5.porting.SessionWrapper;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.persistence.PersistenceException;
import org.hibernate.FlushMode;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.ScrollMode;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTransaction
implements DataStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(HibernateTransaction.class);
    private final org.hibernate.Session session;
    private final SessionWrapper sessionWrapper;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final boolean isScrollEnabled;

    protected HibernateTransaction(org.hibernate.Session session, boolean isScrollEnabled, ScrollMode scrollMode) {
        this.session = session;
        FlushMode flushMode = session.getHibernateFlushMode();
        if (flushMode != FlushMode.COMMIT && flushMode != FlushMode.MANUAL) {
            session.setHibernateFlushMode(FlushMode.COMMIT);
        }
        this.sessionWrapper = new SessionWrapper(session);
        this.isScrollEnabled = isScrollEnabled;
    }

    public void delete(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.delete(object));
    }

    public void save(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.saveOrUpdate(object));
    }

    public void flush(RequestScope requestScope) {
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            this.hibernateFlush(requestScope);
        }
        catch (PersistenceException e) {
            log.error("Caught hibernate exception during flush", (Throwable)e);
            throw new TransactionException((Throwable)e);
        }
    }

    protected void hibernateFlush(RequestScope requestScope) {
        FlushMode flushMode = this.session.getHibernateFlushMode();
        if (flushMode != FlushMode.MANUAL) {
            this.session.flush();
        }
    }

    public void commit(RequestScope scope) {
        try {
            this.flush(scope);
            this.session.getTransaction().commit();
        }
        catch (PersistenceException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void createObject(Object entity, RequestScope scope) {
        this.deferredTasks.add(() -> this.session.persist(entity));
    }

    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        try {
            EntityDictionary dictionary = scope.getDictionary();
            Class idType = dictionary.getIdType(entityClass);
            String idField = dictionary.getIdFieldName(entityClass);
            Path.PathElement idPath = new Path.PathElement(entityClass, idType, idField);
            Object idExpression = id != null ? new InPredicate(idPath, (Object[])new Serializable[]{id}) : new FalsePredicate(idPath);
            FilterExpression joinedExpression = filterExpression.map(arg_0 -> HibernateTransaction.lambda$loadObject$3((FilterPredicate)idExpression, arg_0)).orElse((FilterExpression)idExpression);
            QueryWrapper query = (QueryWrapper)new RootCollectionFetchQueryBuilder(entityClass, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(Optional.of(joinedExpression)).build();
            return query.getQuery().uniqueResult();
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public Iterable<Object> loadObjects(Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        pagination.ifPresent(p -> {
            if (p.isGenerateTotals()) {
                p.setPageTotals(this.getTotalRecords(entityClass, filterExpression, scope.getDictionary()).longValue());
            }
        });
        QueryWrapper query = (QueryWrapper)new RootCollectionFetchQueryBuilder(entityClass, scope.getDictionary(), (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
        if (this.isScrollEnabled) {
            return new ScrollableIterator<Object>(query.getQuery().scroll());
        }
        return query.getQuery().list();
    }

    public Object getRelation(DataStoreTransaction relationTx, Object entity, String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        Collection filteredVal;
        EntityDictionary dictionary = scope.getDictionary();
        Object val = PersistentResource.getValue((Object)entity, (String)relationName, (RequestScope)scope);
        if (val instanceof Collection && (filteredVal = (Collection)val) instanceof AbstractPersistentCollection) {
            if (!filterExpression.isPresent() && !sorting.isPresent() && (!pagination.isPresent() || pagination.isPresent() && pagination.get().isDefaultInstance())) {
                return val;
            }
            Class relationClass = dictionary.getParameterizedType(entity, relationName);
            RelationshipImpl relationship = new RelationshipImpl(dictionary.lookupEntityClass(entity.getClass()), relationClass, relationName, entity, filteredVal);
            pagination.ifPresent(p -> {
                if (p.isGenerateTotals()) {
                    p.setPageTotals(this.getTotalRecords((AbstractHQLQueryBuilder.Relationship)relationship, filterExpression, dictionary).longValue());
                }
            });
            QueryWrapper query = (QueryWrapper)new SubCollectionFetchQueryBuilder((AbstractHQLQueryBuilder.Relationship)relationship, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
            if (query != null) {
                return query.getQuery().list();
            }
        }
        return val;
    }

    private <T> Long getTotalRecords(Class<T> entityClass, Optional<FilterExpression> filterExpression, EntityDictionary dictionary) {
        QueryWrapper query = (QueryWrapper)new RootCollectionPageTotalsQueryBuilder(entityClass, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).build();
        return (Long)query.getQuery().uniqueResult();
    }

    private <T> Long getTotalRecords(AbstractHQLQueryBuilder.Relationship relationship, Optional<FilterExpression> filterExpression, EntityDictionary dictionary) {
        QueryWrapper query = (QueryWrapper)new SubCollectionPageTotalsQueryBuilder(relationship, dictionary, (Session)this.sessionWrapper).withPossibleFilterExpression(filterExpression).build();
        return (Long)query.getQuery().uniqueResult();
    }

    public void close() throws IOException {
        if (this.session.isOpen() && this.session.getTransaction().getStatus().canRollback()) {
            this.session.getTransaction().rollback();
            throw new IOException("Transaction not closed");
        }
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }

    private static /* synthetic */ FilterExpression lambda$loadObject$3(FilterPredicate idExpression, FilterExpression fe) {
        return new AndFilterExpression(fe, (FilterExpression)idExpression);
    }
}

