/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.inmemory;

import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.datastores.inmemory.InMemoryTransaction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class InMemoryDataStore
implements DataStore {
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> dataStore = new ConcurrentHashMap();
    private EntityDictionary dictionary;
    private final Package beanPackage;

    public InMemoryDataStore(Package beanPackage) {
        this.beanPackage = beanPackage;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)this.beanPackage.getName(), (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
        reflections.getTypesAnnotatedWith(Entity.class).stream().filter(entityAnnotatedClass -> entityAnnotatedClass.getPackage().getName().startsWith(this.beanPackage.getName())).forEach(arg_0 -> ((EntityDictionary)dictionary).bindEntity(arg_0));
        this.dictionary = dictionary;
    }

    public DataStoreTransaction beginTransaction() {
        return new InMemoryTransaction(this.dataStore, this.dictionary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data store contents ");
        for (Class cls : this.dataStore.keySet()) {
            sb.append("\n Table ").append(cls).append(" contents \n");
            ConcurrentHashMap<String, Object> data = this.dataStore.get(cls);
            for (Map.Entry<String, Object> e : data.entrySet()) {
                sb.append(" Id: ").append(e.getKey()).append(" Value: ").append(e.getValue());
            }
        }
        return sb.toString();
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public Package getBeanPackage() {
        return this.beanPackage;
    }
}

