/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.inmemory;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.datastores.inmemory.Operation;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Id;

public class InMemoryTransaction
implements DataStoreTransaction {
    private static final ConcurrentHashMap<Class<?>, AtomicLong> TYPEIDS = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> dataStore;
    private final List<Operation> operations;
    private final EntityDictionary dictionary;

    public InMemoryTransaction(ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> dataStore, EntityDictionary dictionary) {
        this.dataStore = dataStore;
        this.dictionary = dictionary;
        this.operations = new ArrayList<Operation>();
    }

    public void flush() {
    }

    public void save(Object object) {
        if (object == null) {
            return;
        }
        String id = this.dictionary.getId(object);
        if (id.equals("0")) {
            this.setId(object, this.dictionary.getId(this.createObject(object.getClass())));
        }
        id = this.dictionary.getId(object);
        this.operations.add(new Operation(id, object, object.getClass(), false));
    }

    public void delete(Object object) {
        if (object == null) {
            return;
        }
        String id = this.dictionary.getId(object);
        this.operations.add(new Operation(id, object, object.getClass(), true));
    }

    public void commit() {
        this.operations.forEach(op -> {
            Class<?> cls = op.getType();
            ConcurrentHashMap<String, Object> data = this.dataStore.get(cls);
            Object instance = op.getInstance();
            if (instance == null) {
                return;
            }
            String id = op.getId();
            if (op.getDelete().booleanValue()) {
                if (data != null) {
                    data.remove(id);
                }
            } else {
                if (data == null) {
                    data = new ConcurrentHashMap();
                    this.dataStore.put(cls, data);
                }
                data.put(id, instance);
            }
        });
        this.operations.clear();
    }

    public <T> T createObject(Class<T> entityClass) {
        if (this.dataStore.get(entityClass) == null) {
            this.dataStore.putIfAbsent(entityClass, new ConcurrentHashMap());
            TYPEIDS.putIfAbsent(entityClass, new AtomicLong(1L));
        }
        AtomicLong idValue = TYPEIDS.get(entityClass);
        String id = String.valueOf(idValue.getAndIncrement());
        try {
            T instance = entityClass.newInstance();
            this.setId(instance, id);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setId(Object value, String id) {
        for (Class<?> cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
            for (Method method : cls.getMethods()) {
                if (!method.isAnnotationPresent(Id.class) || !method.getName().startsWith("get")) continue;
                String setName = "set" + method.getName().substring(3);
                for (Method setMethod : cls.getMethods()) {
                    if (!setMethod.getName().equals(setName) || setMethod.getParameterCount() != 1) continue;
                    try {
                        setMethod.invoke(value, CoerceUtil.coerce((Object)id, setMethod.getParameters()[0].getType()));
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
        }
    }

    public <T> T loadObject(Class<T> loadClass, Serializable id) {
        ConcurrentHashMap<String, Object> objs = this.dataStore.get(loadClass);
        if (objs == null) {
            return null;
        }
        return (T)objs.get(id.toString());
    }

    public <T> List<T> loadObjects(Class<T> loadClass) {
        ConcurrentHashMap<String, Object> objs = this.dataStore.get(loadClass);
        if (objs == null) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        objs.forEachValue(1L, results::add);
        return results;
    }

    public void close() throws IOException {
        this.operations.clear();
    }
}

