/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.inmemory;

import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class InMemoryDataStore
implements DataStore {
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> database = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, AtomicLong> TYPEIDS = new ConcurrentHashMap();
    private EntityDictionary dictionary;
    private Package beanPackage;

    public InMemoryDataStore(Package beanPackage) {
        this.beanPackage = beanPackage;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)this.beanPackage.getName(), (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
        for (Class a : reflections.getTypesAnnotatedWith(Entity.class)) {
            if (!a.getPackage().getName().startsWith(this.beanPackage.getName())) continue;
            dictionary.bindEntity(a);
        }
        this.dictionary = dictionary;
    }

    public DataStoreTransaction beginTransaction() {
        return new InMemoryTransaction(this.dictionary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Database contents ");
        for (Class cls : this.database.keySet()) {
            sb.append("\n Table ").append(cls).append(" contents \n");
            ConcurrentHashMap<String, Object> data = this.database.get(cls);
            for (Map.Entry<String, Object> e : data.entrySet()) {
                sb.append(" Id: ").append(e.getKey()).append(" Value: ").append(e.getValue());
            }
        }
        return sb.toString();
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public Package getBeanPackage() {
        return this.beanPackage;
    }

    public class InMemoryTransaction
    implements DataStoreTransaction {
        private final List<Operation> operations;
        private final EntityDictionary dictionary;

        public InMemoryTransaction(EntityDictionary dictionary) {
            this.dictionary = dictionary;
            this.operations = new ArrayList<Operation>();
        }

        public void flush() {
        }

        public void save(Object object) {
            if (object == null) {
                return;
            }
            String id = this.dictionary.getId(object);
            if (id.equals("0")) {
                this.setId(object, this.dictionary.getId(this.createObject(object.getClass())));
            }
            id = this.dictionary.getId(object);
            this.operations.add(new Operation(id, object, object.getClass(), false));
        }

        public void delete(Object object) {
            if (object == null) {
                return;
            }
            String id = this.dictionary.getId(object);
            this.operations.add(new Operation(id, object, object.getClass(), true));
        }

        public void commit() {
            this.operations.forEach(op -> {
                Class<?> cls = op.getType();
                ConcurrentHashMap<String, Object> data = (ConcurrentHashMap<String, Object>)InMemoryDataStore.this.database.get(cls);
                Object instance = op.getInstance();
                if (instance == null) {
                    return;
                }
                String id = op.getId();
                if (op.getDelete().booleanValue()) {
                    if (data != null) {
                        data.remove(id);
                    }
                } else {
                    if (data == null) {
                        data = new ConcurrentHashMap<String, Object>();
                        InMemoryDataStore.this.database.put(cls, data);
                    }
                    data.put(id, instance);
                }
            });
            this.operations.clear();
        }

        public <T> T createObject(Class<T> entityClass) {
            if (InMemoryDataStore.this.database.get(entityClass) == null) {
                InMemoryDataStore.this.database.putIfAbsent(entityClass, new ConcurrentHashMap());
                TYPEIDS.putIfAbsent(entityClass, new AtomicLong(1L));
            }
            AtomicLong idValue = (AtomicLong)TYPEIDS.get(entityClass);
            String id = String.valueOf(idValue.getAndIncrement());
            try {
                T instance = entityClass.newInstance();
                this.setId(instance, id);
                return instance;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setId(Object value, String id) {
            for (Class<?> cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
                for (Method method : cls.getMethods()) {
                    if (!method.isAnnotationPresent(Id.class) || !method.getName().startsWith("get")) continue;
                    String setName = "set" + method.getName().substring(3);
                    for (Method setMethod : cls.getMethods()) {
                        if (!setMethod.getName().equals(setName) || setMethod.getParameterCount() != 1) continue;
                        try {
                            setMethod.invoke(value, this.coerce(id, setMethod.getParameters()[0].getType()));
                        }
                        catch (ReflectiveOperationException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
            }
        }

        private Object coerce(Object value, Class<?> fieldClass) {
            if (value == null || fieldClass == null || fieldClass.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (Short.TYPE.isAssignableFrom(fieldClass) && value instanceof String) {
                return Short.valueOf((String)value);
            }
            if (Byte.TYPE.isAssignableFrom(fieldClass) && value instanceof String) {
                return Byte.valueOf((String)value);
            }
            if (Float.TYPE.isAssignableFrom(fieldClass) && value instanceof String) {
                return Float.valueOf((String)value);
            }
            if (Double.TYPE.isAssignableFrom(fieldClass) && value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (Integer.TYPE.isAssignableFrom(fieldClass) && value instanceof String) {
                return Integer.valueOf((String)value);
            }
            if (Long.TYPE.isAssignableFrom(fieldClass) && value instanceof String) {
                return Long.valueOf((String)value);
            }
            if (Short.class.isAssignableFrom(fieldClass) && value instanceof String) {
                return Short.valueOf((String)value);
            }
            if (Byte.class.isAssignableFrom(fieldClass) && value instanceof String) {
                return Byte.valueOf((String)value);
            }
            if (Float.class.isAssignableFrom(fieldClass) && value instanceof String) {
                return Float.valueOf((String)value);
            }
            if (Double.class.isAssignableFrom(fieldClass) && value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (Integer.class.isAssignableFrom(fieldClass) && value instanceof String) {
                return Integer.valueOf((String)value);
            }
            if (Long.class.isAssignableFrom(fieldClass) && value instanceof String) {
                return Long.valueOf((String)value);
            }
            return CoerceUtil.coerce((Object)value, fieldClass);
        }

        public <T> T loadObject(Class<T> loadClass, Serializable id) {
            ConcurrentHashMap objs = (ConcurrentHashMap)InMemoryDataStore.this.database.get(loadClass);
            if (objs == null) {
                return null;
            }
            return (T)objs.get(id.toString());
        }

        public <T> List<T> loadObjects(Class<T> loadClass) {
            ConcurrentHashMap objs = (ConcurrentHashMap)InMemoryDataStore.this.database.get(loadClass);
            if (objs == null) {
                return Collections.emptyList();
            }
            ArrayList results = new ArrayList();
            objs.forEachValue(1L, results::add);
            return results;
        }

        public void close() throws IOException {
            this.operations.clear();
        }

        private class Operation {
            private final String id;
            private final Object instance;
            private final Class<?> type;
            private final Boolean delete;

            @ConstructorProperties(value={"id", "instance", "type", "delete"})
            public Operation(String id, Object instance, Class<?> type, Boolean delete) {
                this.id = id;
                this.instance = instance;
                this.type = type;
                this.delete = delete;
            }

            public String getId() {
                return this.id;
            }

            public Object getInstance() {
                return this.instance;
            }

            public Class<?> getType() {
                return this.type;
            }

            public Boolean getDelete() {
                return this.delete;
            }
        }
    }
}

