/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.parsec.constraint.validators;

import com.yahoo.parsec.constraint.validators.LatLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class LatLongValidator
implements ConstraintValidator<LatLong, String> {
    private static final String LATLONG_PATTERN = "^[NS]([0-8]?[0-9]|90)(\\.[0-9]{1,6})?[,;][EW]((1?[0-7]?|[0-9]?)[0-9]|180)(\\.[0-9]{1,6})?$";
    private Pattern pattern;

    public void initialize(LatLong constraintAnnotation) {
        this.pattern = Pattern.compile(LATLONG_PATTERN);
    }

    public boolean isValid(String input, ConstraintValidatorContext context) {
        boolean isValid = false;
        if (null == input) {
            isValid = true;
        } else {
            Matcher matcher = this.pattern.matcher(input);
            if (matcher.matches()) {
                isValid = true;
            }
        }
        return isValid;
    }
}

