/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.parsec.constraint.validators;

import com.yahoo.parsec.constraint.validators.Msisdn;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MsisdnValidator
implements ConstraintValidator<Msisdn, String> {
    private static final String MSISDN_PATTERN = "^[1-9][0-9]{2,14}$";
    private Pattern pattern;

    public void initialize(Msisdn constraintAnnotation) {
        this.pattern = Pattern.compile(MSISDN_PATTERN);
    }

    public boolean isValid(String input, ConstraintValidatorContext context) {
        boolean isValid = false;
        if (null == input) {
            isValid = true;
        } else {
            Matcher matcher = this.pattern.matcher(input);
            if (matcher.matches()) {
                isValid = true;
            }
        }
        return isValid;
    }
}

