/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.parsec.constraint.validators;

import com.yahoo.parsec.constraint.validators.CountryCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class CountryCodeValidator
implements ConstraintValidator<CountryCode, String> {
    private static final Set<String> COUNTRIES = new HashSet<String>();

    public void initialize(CountryCode countryCodeAnnotation) {
    }

    public boolean isValid(String ccode, ConstraintValidatorContext context) {
        if (ccode == null) {
            return true;
        }
        for (char c : ccode.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return COUNTRIES.contains(ccode.toUpperCase(Locale.ENGLISH));
    }

    static {
        String[] ccodes = Locale.getISOCountries();
        COUNTRIES.addAll(Arrays.asList(ccodes));
    }
}

