/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.parsec.constraint.validators;

import com.yahoo.parsec.constraint.validators.LanguageTag;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class LanguageTagValidator
implements ConstraintValidator<LanguageTag, String> {
    private static final Set<String> LANGUAGES;

    public void initialize(LanguageTag countryCodeAnnotation) {
    }

    public boolean isValid(String lang, ConstraintValidatorContext context) {
        if (lang == null) {
            return true;
        }
        return LANGUAGES.contains(lang);
    }

    static {
        Locale[] locales;
        LANGUAGES = new HashSet<String>();
        for (Locale l : locales = Locale.getAvailableLocales()) {
            LANGUAGES.add(l.toString().replace('_', '-'));
        }
    }
}

