/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.parsec.validation;

import com.yahoo.parsec.validation.JaxbError;
import com.yahoo.parsec.validation.JaxbException;
import com.yahoo.parsec.validation.ParsecErrorResponse;
import com.yahoo.parsec.validation.ValidateUtil;
import java.util.ArrayList;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class JaxbExceptionMapper
implements ExceptionMapper<JaxbException> {
    public static final String PROP_JAXB_DEFAULT_ERROR_CODE = "parsec.config.jaxb.defaultErrorCode";
    public static final String PROP_JAXB_DEFAULT_ERROR_MSG = "parsec.config.jaxb.defaultErrorMsg";
    @Context
    private Configuration config;

    public Response toResponse(JaxbException exception) {
        int errorCode = 1;
        String errorMsg = "JAXB convert/validate error, please check your input data";
        if (this.config != null) {
            Object propErrorCode = this.config.getProperty(PROP_JAXB_DEFAULT_ERROR_CODE);
            Object propErrorMsg = this.config.getProperty(PROP_JAXB_DEFAULT_ERROR_MSG);
            if (propErrorCode != null) {
                errorCode = Integer.valueOf(propErrorCode.toString());
            }
            if (propErrorMsg != null) {
                errorMsg = propErrorMsg.toString();
            }
        }
        ArrayList<JaxbError> errors = new ArrayList<JaxbError>();
        errors.add(new JaxbError(exception.getMessage()));
        ParsecErrorResponse errorResponse = ValidateUtil.buildErrorResponse(errors, errorCode, errorMsg);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new GenericEntity<ParsecErrorResponse<JaxbError>>(errorResponse){}).build();
    }
}

