/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.parsec.validation;

import com.yahoo.parsec.validation.ParsecErrorResponse;
import com.yahoo.parsec.validation.ValidateUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.server.validation.ValidationError;
import org.glassfish.jersey.server.validation.internal.LocalizationMessages;
import org.glassfish.jersey.server.validation.internal.ValidationExceptionMapper;
import org.glassfish.jersey.server.validation.internal.ValidationHelper;

public class ParsecValidationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final Logger LOGGER = Logger.getLogger(ValidationExceptionMapper.class.getName());
    private static final String DEFAULT_MSG = "constraint violation validate error";
    private static final int DEFAULT_CODE = 0;
    public static final String PROP_VALIDATION_DEFAULT_ERROR_CODE = "parsec.config.validation.defaultErrorCode";
    public static final String PROP_VALIDATION_DEFAULT_ERROR_MSG = "parsec.config.validation.defaultErrorMsg";
    @Context
    private Configuration config;

    public Response toResponse(ConstraintViolationException e) {
        int code = 0;
        String message = DEFAULT_MSG;
        if (this.config != null) {
            Object propErrorMsg;
            Object propErrorCode = this.config.getProperty(PROP_VALIDATION_DEFAULT_ERROR_CODE);
            if (propErrorCode != null) {
                code = Integer.valueOf(propErrorCode.toString());
            }
            if ((propErrorMsg = this.config.getProperty(PROP_VALIDATION_DEFAULT_ERROR_MSG)) != null) {
                message = propErrorMsg.toString();
            }
        }
        return this.toResponse(e, code, message);
    }

    private Response toResponse(ConstraintViolationException e, int code, String message) {
        LOGGER.log(Level.FINER, LocalizationMessages.CONSTRAINT_VIOLATIONS_ENCOUNTERED(), (Throwable)e);
        List errors = ValidationHelper.constraintViolationToValidationErrors((ConstraintViolationException)e);
        ParsecErrorResponse errorResponse = ValidateUtil.buildErrorResponse(errors, code, message);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new GenericEntity<ParsecErrorResponse<ValidationError>>(errorResponse){}).build();
    }
}

