package com.yazantarifi.kmm.sopy.api

sealed class SopyApplicationState<out T> {
    data class Success<out T : Any>(
        val data: T?
    ) : SopyApplicationState<T>()

    object Loading: SopyApplicationState<Nothing>()
    object Loaded: SopyApplicationState<Nothing>()

    data class Error(
        val exception: Throwable? = null,
        val responseCode: Int = -1
    ) : SopyApplicationState<Nothing>()

    fun handleResult(onSuccess: ((responseData: T?) -> Unit)?, onError: ((error: Error) -> Unit)?, onLoading: ((loadingState: Boolean) -> Unit)? = null) {
        when (this) {
            is Success -> {
                onSuccess?.invoke(this.data)
            }
            is Error -> {
                onError?.invoke(this)
            }
            is Loading -> {
                onLoading?.invoke(true)
            }
            is Loaded -> {
                onLoading?.invoke(false)
            }
        }
    }
}