/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms;

import com.zuunr.forms.FormField;
import com.zuunr.forms.FormFields;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;
import com.zuunr.json.TypedObject;

public class Form
extends TypedObject<Form> {
    public static final Form EMPTY = (Form)((Object)JsonObject.EMPTY.put("value", JsonArray.EMPTY).jsonValue().as(Form.class));
    private JsonObject formFieldsByName;
    private JsonObject requiredFormFields;

    private Form(JsonObject jsonObject) {
        super(jsonObject);
    }

    private static final JsonObject fromSource(JsonValue source) {
        JsonObject sourceJsonObject = (JsonObject)source.getValue(JsonObject.class);
        JsonObject.JsonObjectBuilder builder = sourceJsonObject.builder();
        String href = (String)source.get("href", JsonValue.NULL).as(String.class);
        if (href != null) {
            builder.put("href", href);
        }
        builder.put("exclusive", ((Boolean)sourceJsonObject.get("exclusive", JsonValue.TRUE).getValue(Boolean.class)).booleanValue());
        builder.put("value", (JsonValueSupport)sourceJsonObject.get("value", JsonArray.EMPTY).as(FormFields.class));
        return builder.build();
    }

    private Form(JsonValue jsonValue) {
        super(Form.fromSource(jsonValue));
    }

    public FormBuilder builder() {
        return new FormBuilder(this.jsonObject);
    }

    public String href() {
        return (String)this.jsonObject.get("href", JsonValue.NULL).as(String.class);
    }

    public FormFields formFields() {
        return (FormFields)this.jsonObject.get("value", JsonValue.NULL).as(FormFields.class);
    }

    public JsonArray value() {
        return (JsonArray)this.jsonObject.get("value", JsonValue.NULL).getValue(JsonArray.class);
    }

    public Boolean required() {
        return (Boolean)this.jsonObject.get("required", JsonValue.FALSE).getValue(Boolean.class);
    }

    public Boolean mustBeNull() {
        return (Boolean)this.jsonObject.get("mustBeNull", JsonValue.FALSE).getValue(Boolean.class);
    }

    public Boolean nullable() {
        return (Boolean)this.jsonObject.get("nullable", JsonValue.FALSE).getValue(Boolean.class);
    }

    public Boolean exclusive() {
        return (Boolean)this.jsonObject.get("exclusive", JsonValue.TRUE).getValue(Boolean.class);
    }

    public FormField formField(String fieldName) {
        return (FormField)this.formFieldsByName().get(fieldName, JsonValue.NULL).as(FormField.class);
    }

    public JsonObject formFieldsByName() {
        if (this.formFieldsByName == null) {
            JsonObject.JsonObjectBuilder formFieldsCacheBuilder = JsonObject.EMPTY.builder();
            for (FormField formField : this.formFields().asList()) {
                formFieldsCacheBuilder = formFieldsCacheBuilder.put(formField.name(), (JsonValueSupport)formField);
            }
            this.formFieldsByName = formFieldsCacheBuilder.build();
        }
        return this.formFieldsByName;
    }

    public JsonObject requiredFormFields() {
        if (this.requiredFormFields == null) {
            JsonObject.JsonObjectBuilder formFieldsCacheBuilder = JsonObject.EMPTY.builder();
            for (FormField formField : this.formFields().asList()) {
                if (!formField.required().booleanValue()) continue;
                formFieldsCacheBuilder = formFieldsCacheBuilder.put(formField.name(), (JsonValueSupport)formField);
            }
            this.requiredFormFields = formFieldsCacheBuilder.build();
        }
        return this.requiredFormFields;
    }

    protected Form createNew(JsonObject jsonObject) {
        return new Form(jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public static class FormBuilder {
        JsonObject.JsonObjectBuilder jsonObjectBuilder;

        private FormBuilder(JsonObject jsonObject) {
            this.jsonObjectBuilder = jsonObject.builder();
        }

        public FormBuilder href(String href) {
            this.jsonObjectBuilder.put("href", href);
            return this;
        }

        public FormBuilder value(FormFields formFields) {
            this.jsonObjectBuilder.put("value", (JsonValueSupport)formFields);
            return this;
        }

        public FormBuilder value(FormFields.FormFieldsBuilder formFieldsBuilder) {
            this.jsonObjectBuilder.put("value", (JsonValueSupport)formFieldsBuilder.build());
            return this;
        }

        public FormBuilder exclusive(Boolean exclusive) {
            this.jsonObjectBuilder.put("exclusive", exclusive.booleanValue());
            return this;
        }

        public Form build() {
            return new Form(this.jsonObjectBuilder.build().jsonValue());
        }
    }
}

