/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms;

import com.zuunr.forms.ExplicitFormCreator;
import com.zuunr.forms.Form;
import com.zuunr.forms.ValueFormat;
import com.zuunr.forms.formfield.Equals;
import com.zuunr.forms.formfield.Max;
import com.zuunr.forms.formfield.MaxLength;
import com.zuunr.forms.formfield.MaxSize;
import com.zuunr.forms.formfield.Min;
import com.zuunr.forms.formfield.MinLength;
import com.zuunr.forms.formfield.MinSize;
import com.zuunr.forms.formfield.Options;
import com.zuunr.forms.formfield.Pattern;
import com.zuunr.forms.formfield.Type;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectSupport;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormField
implements JsonObjectSupport {
    private static final Logger logger = LoggerFactory.getLogger(FormField.class);
    private static ExplicitFormCreator explicitFormCreator = new ExplicitFormCreator();
    private JsonObject jsonObject;
    private String name;
    private Min min;
    private Max max;
    private MinLength minlength;
    private MaxLength maxlength;
    private MinSize minSize;
    private MaxSize maxSize;
    private Pattern pattern;
    private Boolean required;
    private FormField explicitFormField;

    private FormField(JsonValue source, boolean isExplicit) {
        this(source);
        if (isExplicit) {
            this.explicitFormField = this;
        }
    }

    public FormField(JsonValue source) {
        try {
            this.init(source);
        }
        catch (Exception e) {
            logger.error("Bad form field: {}", (Object)source.asJson());
            throw new RuntimeException(e);
        }
    }

    private void init(JsonValue source) {
        Type type;
        ValueFormat element;
        Options options;
        Boolean nullable;
        Boolean mustBeNull;
        JsonObject in = (JsonObject)source.getValue(JsonObject.class);
        JsonObject.JsonObjectBuilder builder = JsonObject.EMPTY.builder().put("name", in.get("name"));
        this.name = (String)in.get("name").getValue(String.class);
        if (in.get("desc", JsonValue.NULL).getValue(String.class) != null) {
            builder.put("desc", in.get("desc"));
        }
        if (in.get("equals", JsonValue.NULL).as(Equals.class) != null) {
            builder.put("equals", in.get("equals"));
        }
        if (in.get("eform", JsonValue.NULL).as(Form.class) != null) {
            builder.put("eform", in.get("eform"));
        }
        if (in.get("form", JsonValue.NULL).as(Form.class) != null) {
            builder.put("form", in.get("form"));
        }
        if ((mustBeNull = (Boolean)in.get("mustBeNull", JsonValue.NULL).getValue(Boolean.class)) != null) {
            builder.put("mustBeNull", mustBeNull.booleanValue());
        }
        if ((nullable = (Boolean)in.get("nullable", JsonValue.NULL).getValue(Boolean.class)) != null) {
            builder.put("nullable", ((Boolean)in.get("nullable", nullable).getValue(Boolean.class)).booleanValue());
        }
        if ((options = (Options)in.get("options", JsonValue.NULL).as(Options.class)) != null) {
            builder.put("options", (JsonValueSupport)options);
        }
        if ((element = (ValueFormat)in.get("element", JsonValue.NULL).as(ValueFormat.class)) != null) {
            builder.put("element", (JsonValueSupport)element);
        }
        this.required = (Boolean)in.get("required", JsonValue.NULL).getValue(Boolean.class);
        if (this.required != null) {
            builder.put("required", in.get("required"));
        }
        Type type2 = type = mustBeNull != null && mustBeNull != false ? null : (Type)in.get("type", (JsonValueSupport)Type.STRING).as(Type.class);
        if (type != null) {
            builder.put("type", (JsonValueSupport)type);
            if (Type.INTEGER.equals(type)) {
                if (in.get("max", JsonValue.NULL).asInteger() != null) {
                    this.max = new Max(in.get("max"));
                    builder.put("max", this.max.asJsonValue());
                }
                if (in.get("min", JsonValue.NULL).asInteger() != null) {
                    this.min = new Min(in.get("min"));
                    builder.put("min", this.min.asJsonValue());
                }
            } else if (Type.DECIMAL.equals(type)) {
                if (in.get("max", JsonValue.NULL).getValue(BigDecimal.class) != null) {
                    this.max = new Max(in.get("max"));
                    builder.put("max", this.max.asJsonValue());
                }
                if (in.get("min", JsonValue.NULL).getValue(BigDecimal.class) != null) {
                    this.min = new Min(in.get("min"));
                    builder.put("min", this.min.asJsonValue());
                }
            } else if (type.isStringTypeOrSubtypeOfString()) {
                if (in.get("pattern", JsonValue.NULL).getValue(String.class) != null) {
                    this.pattern = new Pattern(in.get("pattern"));
                    builder.put("pattern", this.pattern.asJsonValue());
                }
                if (in.get("maxlength", JsonValue.NULL).asInteger() != null) {
                    this.maxlength = new MaxLength(in.get("maxlength"));
                    builder.put("maxlength", this.maxlength.asJsonValue());
                }
                if (in.get("minlength", JsonValue.NULL).asInteger() != null) {
                    this.minlength = new MinLength(in.get("minlength"));
                    builder.put("minlength", this.minlength.asJsonValue());
                }
                if (in.get("max", JsonValue.NULL).getValue(String.class) != null) {
                    this.max = new Max(in.get("max"));
                    builder.put("max", this.max.asJsonValue());
                }
                if (in.get("min", JsonValue.NULL).getValue(String.class) != null) {
                    this.min = new Min(in.get("min"));
                    builder.put("min", this.min.asJsonValue());
                }
            } else if (Type.ARRAY.equals(type) || Type.SET.equals(type)) {
                if (in.get("maxsize", JsonValue.NULL).asInteger() != null) {
                    this.maxSize = new MaxSize(in.get("maxsize"));
                    builder.put("maxsize", this.maxSize.asJsonValue());
                }
                if (in.get("minsize", JsonValue.NULL).asInteger() != null) {
                    this.minSize = new MinSize(in.get("minsize"));
                    builder.put("minsize", this.minSize.asJsonValue());
                }
            } else if (Type.DATE.equals(type)) {
                if (in.get("max", JsonValue.NULL).getValue(String.class) != null) {
                    this.max = new Max(in.get("max"));
                    builder.put("max", this.max.asJsonValue());
                }
                if (in.get("min", JsonValue.NULL).getValue(String.class) != null) {
                    this.min = new Min(in.get("min"));
                    builder.put("min", this.min.asJsonValue());
                }
            }
        }
        this.jsonObject = builder.build();
    }

    public FormFieldBuilder builder() {
        return new FormFieldBuilder(this.jsonObject);
    }

    public static FormFieldBuilder builder(String formFieldName) {
        return new FormField(JsonObject.EMPTY.builder().put("name", formFieldName).build().jsonValue()).builder();
    }

    public MinLength minlength() {
        return this.minlength;
    }

    public MaxLength maxlength() {
        return this.maxlength;
    }

    public Boolean mustBeNull() {
        return (Boolean)this.jsonObject.get("mustBeNull", JsonValue.NULL).getValue(Boolean.class);
    }

    public Max max() {
        return this.max;
    }

    public Min min() {
        return this.min;
    }

    public String name() {
        return this.name;
    }

    public Boolean nullable() {
        return (Boolean)this.jsonObject.get("nullable", JsonValue.NULL).getValue(Boolean.class);
    }

    public ValueFormat element() {
        return (ValueFormat)this.jsonObject.get("element", JsonValue.NULL).as(ValueFormat.class);
    }

    public Options options() {
        return (Options)this.jsonObject.get("options", JsonValue.NULL).as(Options.class);
    }

    public Type type() {
        return (Type)this.jsonObject.get("type", JsonValue.NULL).as(Type.class);
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Form form() {
        return (Form)((Object)this.jsonObject.get("form", JsonValue.NULL).as(Form.class));
    }

    public Form eform() {
        return (Form)((Object)this.jsonObject.get("eform", JsonValue.NULL).as(Form.class));
    }

    public Boolean required() {
        return (Boolean)this.jsonObject.get("required", JsonValue.NULL).getValue(Boolean.class);
    }

    public JsonObject asJsonObject() {
        return this.jsonObject;
    }

    public JsonValue asJsonValue() {
        return this.jsonObject.jsonValue();
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.jsonObject.equals((Object)((FormField)obj).jsonObject);
    }

    public FormField asExplicitFormField() {
        if (this.explicitFormField == null) {
            this.explicitFormField = new FormField(explicitFormCreator.createExplicitFormField(this).jsonValue(), true);
        }
        return this.explicitFormField;
    }

    public static class FormFieldBuilder {
        JsonObject.JsonObjectBuilder jsonObjectBuilder;

        private FormFieldBuilder(JsonObject jsonObject) {
            this.jsonObjectBuilder = jsonObject.builder();
        }

        public FormFieldBuilder desc(String description) {
            this.jsonObjectBuilder.put("desc", description);
            return this;
        }

        public FormFieldBuilder eform(Form form) {
            this.jsonObjectBuilder.put("eform", form.asJsonValue());
            return this;
        }

        public FormFieldBuilder element(ValueFormat elementValueFormat) {
            this.jsonObjectBuilder.put("element", elementValueFormat.asJsonValue());
            return this;
        }

        public FormFieldBuilder equalTo(Equals paths) {
            this.jsonObjectBuilder.put("equals", paths.asJsonValue());
            return this;
        }

        public FormFieldBuilder form(Form form) {
            this.jsonObjectBuilder.put("form", form.asJsonValue());
            return this;
        }

        public FormFieldBuilder max(Integer max) {
            this.jsonObjectBuilder.put("max", max);
            return this;
        }

        public FormFieldBuilder max(BigDecimal max) {
            this.jsonObjectBuilder.put("max", max);
            return this;
        }

        public FormFieldBuilder max(String max) {
            this.jsonObjectBuilder.put("max", max);
            return this;
        }

        public FormFieldBuilder maxlength(Integer maxlength) {
            this.jsonObjectBuilder.put("maxlength", maxlength);
            return this;
        }

        public FormFieldBuilder min(Integer min) {
            this.jsonObjectBuilder.put("min", min);
            return this;
        }

        public FormFieldBuilder min(BigDecimal min) {
            this.jsonObjectBuilder.put("min", min);
            return this;
        }

        public FormFieldBuilder min(String min) {
            this.jsonObjectBuilder.put("min", min);
            return this;
        }

        public FormFieldBuilder minlength(Integer minlength) {
            this.jsonObjectBuilder.put("minlength", minlength);
            return this;
        }

        public FormFieldBuilder mustBeNull(Boolean mustBeNull) {
            this.jsonObjectBuilder.put("mustBeNull", mustBeNull.booleanValue());
            return this;
        }

        public FormFieldBuilder nullable(Boolean nullable) {
            this.jsonObjectBuilder.put("nullable", nullable.booleanValue());
            return this;
        }

        public FormFieldBuilder pattern(String pattern) {
            this.jsonObjectBuilder.put("pattern", pattern);
            return this;
        }

        public FormFieldBuilder required(Boolean required) {
            this.jsonObjectBuilder.put("required", required.booleanValue());
            return this;
        }

        public FormFieldBuilder type(Type type) {
            this.jsonObjectBuilder.put("type", (JsonValueSupport)type);
            return this;
        }

        public FormFieldBuilder maxsize(Integer maxsize) {
            this.jsonObjectBuilder.put("maxsize", maxsize);
            return this;
        }

        public FormFieldBuilder minsize(Integer minsize) {
            this.jsonObjectBuilder.put("minsize", minsize);
            return this;
        }

        public FormFieldBuilder options(Options options) {
            this.jsonObjectBuilder.put("options", (JsonValueSupport)options);
            return this;
        }

        public FormField build() {
            return new FormField(this.jsonObjectBuilder.build().jsonValue());
        }
    }
}

