/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms;

import com.zuunr.forms.FormField;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonArraySupport;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;
import java.util.Comparator;
import java.util.List;

public class FormFields
implements JsonArraySupport {
    private JsonArray jsonArray;
    private JsonObject formFieldsPerName = null;
    public static FormFields EMPTY = new FormFields(JsonArray.EMPTY);

    private FormFields(JsonValue jsonValue) {
        this((JsonArray)jsonValue.getValue(JsonArray.class));
    }

    private FormFields(JsonArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public FormFieldsBuilder builder() {
        return new FormFieldsBuilder(this.jsonArray);
    }

    public List<FormField> asList() {
        return this.jsonArray.asList(FormField.class);
    }

    public JsonObject formFieldsByName() {
        if (this.formFieldsPerName == null) {
            JsonObject.JsonObjectBuilder builder = JsonObject.EMPTY.builder();
            for (FormField formField : this.asList()) {
                builder.put(formField.name(), (JsonValueSupport)formField);
            }
            this.formFieldsPerName = builder.build();
        }
        return this.formFieldsPerName;
    }

    public FormField of(String name) {
        return (FormField)this.formFieldsByName().get(name, JsonValue.NULL).as(FormField.class);
    }

    public JsonValue asJsonValue() {
        return this.jsonArray.jsonValue();
    }

    public JsonArray asJsonArray() {
        return this.jsonArray;
    }

    public String toString() {
        return this.jsonArray.toString();
    }

    public static class FormFieldsBuilder {
        private static ByNameComparator BY_NAME_COMPARATOR = new ByNameComparator();
        private JsonArray.JsonArrayBuilder jsonArrayBuilder;

        public FormFieldsBuilder(JsonArray jsonArray) {
            this.jsonArrayBuilder = jsonArray.builder();
        }

        public FormFieldsBuilder add(FormField formField) {
            this.jsonArrayBuilder.add(formField.asJsonObject());
            return this;
        }

        public FormFieldsBuilder add(FormField.FormFieldBuilder formFieldBuilder) {
            this.jsonArrayBuilder.add(formFieldBuilder.build().asJsonObject());
            return this;
        }

        public FormFields build() {
            return new FormFields(this.jsonArrayBuilder.build());
        }

        public FormFields buildSortedByName() {
            return new FormFields(this.jsonArrayBuilder.buildSorted((Comparator)BY_NAME_COMPARATOR));
        }

        public FormFields sortAndBuild() {
            return new FormFields(this.jsonArrayBuilder.build());
        }

        private static class ByNameComparator
        implements Comparator<JsonValue> {
            private ByNameComparator() {
            }

            @Override
            public int compare(JsonValue o1, JsonValue o2) {
                JsonObject formField1 = (JsonObject)o1.getValue(JsonObject.class);
                JsonObject formField2 = (JsonObject)o2.getValue(JsonObject.class);
                int result = ((String)formField1.get("name").getValue(String.class)).compareTo((String)formField2.get("name").getValue(String.class));
                if (result == 0) {
                    throw new RuntimeException("There can never be more than one form field per builder");
                }
                return result;
            }
        }
    }
}

