/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms;

import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;

public class FormProviderKey {
    public final String apiName;
    public final String collectionName;
    public final FormType formType;
    public final String fromStatus;
    public final JsonValue toStatus;
    public final JsonObject data;
    public JsonArray asJsonArray;

    private FormProviderKey(String apiName, String collectionName, FormType formType, String fromStatus, JsonValue toStatus) {
        this(apiName, collectionName, formType, fromStatus, toStatus, null);
    }

    private FormProviderKey(String apiName, String collectionName, FormType formType, String fromStatus, JsonValue toStatus, JsonObject data) {
        this.apiName = apiName;
        this.collectionName = collectionName;
        this.formType = formType;
        this.fromStatus = fromStatus;
        this.toStatus = toStatus;
        this.data = data;
        this.asJsonArray = JsonArray.of((Object[])new Object[]{apiName, collectionName, formType.name(), fromStatus == null ? JsonValue.NULL : fromStatus, toStatus == null ? JsonValue.NULL : toStatus});
    }

    public Builder builder() {
        return new Builder().apiName(this.apiName).collectionName(this.collectionName).data(this.data).formType(this.formType).fromStatus(this.fromStatus).toStatus(this.toStatus);
    }

    public static enum FormType {
        REQUEST_BODY,
        RESOURCE_BODY,
        RESOURCE_BODY_RESTRICTED,
        ITEM_QUERY_PARAMS,
        COLLECTION_QUERY_PARAMS,
        RESOURCE_MODEL;

    }

    public static class Builder {
        private String apiName;
        private String collectionName;
        private FormType formType;
        private String fromStatus;
        private JsonValue toStatus;
        private JsonObject data;

        public Builder data(JsonObject data) {
            this.data = data;
            return this;
        }

        public Builder formType(FormType formType) {
            this.formType = formType;
            return this;
        }

        public Builder fromStatus(String fromStatus) {
            this.fromStatus = fromStatus;
            return this;
        }

        public Builder toStatus(JsonValue toStatus) {
            this.toStatus = toStatus;
            return this;
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public FormProviderKey build() {
            return new FormProviderKey(this.apiName, this.collectionName, this.formType, this.fromStatus, this.toStatus, this.data);
        }
    }
}

