/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.filter;

import com.zuunr.forms.Form;
import com.zuunr.forms.FormField;
import com.zuunr.forms.FormFields;
import com.zuunr.forms.ValueFormat;
import com.zuunr.forms.filter.FilterResult;
import com.zuunr.forms.filter.ValidationContext;
import com.zuunr.forms.filter.result.Waste;
import com.zuunr.forms.formfield.Required;
import com.zuunr.forms.formfield.Type;
import com.zuunr.forms.validation.BooleanValidator;
import com.zuunr.forms.validation.DateValidator;
import com.zuunr.forms.validation.DatetimeValidator;
import com.zuunr.forms.validation.DecimalValidator;
import com.zuunr.forms.validation.EqualsValidator;
import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.forms.validation.IntegerValidator;
import com.zuunr.forms.validation.MaxSizeValidator;
import com.zuunr.forms.validation.MinSizeValidator;
import com.zuunr.forms.validation.MustBeNullValidator;
import com.zuunr.forms.validation.NullableValidator;
import com.zuunr.forms.validation.OptionsValidator;
import com.zuunr.forms.validation.StringValidator;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonArraySet;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;
import com.zuunr.json.util.JsonObjectWrapper;

public class FormFilter {
    private static final IntegerValidator integerValidator = new IntegerValidator();
    private static final StringValidator stringValidator = new StringValidator();
    private static final BooleanValidator booleanValidator = new BooleanValidator();
    private static final DecimalValidator decimalValidator = new DecimalValidator();
    private static final MinSizeValidator minSizeValidator = new MinSizeValidator();
    private static final MaxSizeValidator maxSizeValidator = new MaxSizeValidator();
    private static final EqualsValidator equalsValidator = new EqualsValidator();
    private static final NullableValidator nullableValidator = new NullableValidator();
    private static final MustBeNullValidator mustBeNullValidator = new MustBeNullValidator();
    private static final DateValidator dateValidator = new DateValidator();
    private static final DatetimeValidator datetimeValidator = new DatetimeValidator();
    private static final OptionsValidator optionsValidator = new OptionsValidator();

    @Deprecated
    public FilterResult filter(JsonArray formFields, JsonObject data, boolean returnFiltrate, boolean returnWaste) {
        return this.filter(Form.EMPTY.builder().value((FormFields)formFields.as(FormFields.class)).build(), data, returnFiltrate, returnWaste);
    }

    public FilterResult filter(Form form, JsonObject data, boolean returnFiltrate, boolean returnWaste) {
        Waste.Builder wasteBuilder = returnWaste ? Waste.builder() : null;
        ValueFormat format = ValueFormat.EMPTY.builder().type(Type.OBJECT).form(form).build();
        return this.filter(format, data, JsonArray.EMPTY, data, returnFiltrate, wasteBuilder, new ValidationContext(format));
    }

    public FilterResult filter(ValueFormat format, JsonObject data, boolean returnFiltrate, boolean returnWaste) {
        Waste.Builder wasteBuilder = returnWaste ? Waste.builder() : null;
        return this.filter(format, data, JsonArray.EMPTY, data, returnFiltrate, wasteBuilder, new ValidationContext(format));
    }

    public Waste filter(ValueFormat format, JsonValue value, boolean returnWaste, ValidationContext validationContext) {
        JsonObject data = JsonObject.EMPTY.put("data", value);
        Form form = Form.EMPTY.builder().value(FormFields.EMPTY.builder().add((FormField)format.asExplicitValueFormat().asJsonObject().put("name", "data").as(FormField.class)).build()).build();
        ValueFormat nestedFormat = ValueFormat.EMPTY.builder().type(Type.OBJECT).form(form).build();
        FilterResult result = this.filter(nestedFormat, data, false, returnWaste, validationContext);
        return result.waste.removeFirstInAllWasteItemsPaths();
    }

    public FilterResult filter(ValueFormat valueFormat, JsonObject data, boolean returnFiltrate, boolean returnWaste, ValidationContext validationContext) {
        Waste.Builder wasteBuilder = returnWaste ? Waste.builder() : null;
        return this.filter(valueFormat, data, JsonArray.EMPTY, data, returnFiltrate, wasteBuilder, validationContext == null ? new ValidationContext(valueFormat) : validationContext);
    }

    private FilterResult filter(ValueFormat format, JsonObject rootData, JsonArray rootDataPath, JsonObject data, Boolean returnFiltrate, Waste.Builder wasteBuilder, ValidationContext validationContext) {
        return this.filter(format, rootData, rootDataPath, data, returnFiltrate, wasteBuilder, validationContext, true);
    }

    private FilterResult filter(ValueFormat format, JsonObject rootData, JsonArray rootDataPath, JsonObject data, Boolean returnFiltrate, Waste.Builder wasteBuilder, ValidationContext validationContext, boolean extendRootDataPathWithFormFieldName) {
        Form ctxForm;
        ValueFormat ctxFormat;
        Form form = format.form();
        if (format != null && format.href() != null && (ctxFormat = validationContext.getFormat(format.href())) != null) {
            form = ctxFormat.form();
        }
        if (form.href() != null && (ctxForm = validationContext.getForm(form.href())) != null) {
            form = ctxForm;
        }
        JsonArray formFields = form.value();
        Boolean allowUndefinedFields = form.exclusive() == false;
        Boolean returnWaste = wasteBuilder != null;
        JsonObject.JsonObjectBuilder filtrate = returnFiltrate != false ? JsonObject.EMPTY.builder() : null;
        JsonObject.JsonObjectBuilder dataToBeFilteredBuilder = data.builder();
        for (FormField formField : formFields.asList(FormField.class)) {
            String name = formField.name();
            JsonValue fieldValue = data.get(name);
            this.validateFormField(formField.asExplicitFormField(), rootData, extendRootDataPathWithFormFieldName ? rootDataPath.add(name) : rootDataPath, fieldValue, returnFiltrate, returnWaste, filtrate, wasteBuilder, validationContext);
            dataToBeFilteredBuilder = dataToBeFilteredBuilder.remove(name);
        }
        JsonObject dataToBeFiltered = dataToBeFilteredBuilder.build();
        if (returnFiltrate.booleanValue() && allowUndefinedFields.booleanValue()) {
            filtrate = filtrate.putAll(dataToBeFiltered);
        }
        if (returnWaste.booleanValue() && !dataToBeFiltered.isEmpty() && !allowUndefinedFields.booleanValue()) {
            FormFieldValidationResult formFieldValidationResult = FormFieldValidationResult.builder().path(rootDataPath).badValue(data.jsonValue()).add("supportedParams", this.supportedParams(formFields).jsonValue()).build();
            wasteBuilder.add(formFieldValidationResult);
        }
        Waste waste = null;
        if (wasteBuilder != null) {
            waste = wasteBuilder.build();
        }
        FilterResult<JsonObjectWrapper> filterResult = new FilterResult<JsonObjectWrapper>(JsonObjectWrapper.of((JsonObject)(filtrate == null ? null : filtrate.build())), waste);
        return filterResult;
    }

    private void validateFormField(FormField formField, JsonObject rootData, JsonArray rootDataPath, JsonValue fieldValue, Boolean returnFiltrate, Boolean returnWaste, JsonObject.JsonObjectBuilder filtrateBuilder, Waste.Builder wasteBuilder, ValidationContext validationContext) {
        FormFieldValidationResult.Builder fieldValidationBuilder = FormFieldValidationResult.builder().addParamToFiltrate(true);
        if (fieldValue == null) {
            if (formField.required().booleanValue() && returnWaste.booleanValue()) {
                fieldValidationBuilder.add("required", Required.TRUE);
            }
        } else {
            if (JsonValue.NULL.equals((Object)fieldValue)) {
                fieldValidationBuilder = nullableValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.mustBeNull().booleanValue()) {
                fieldValidationBuilder = mustBeNullValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type().isString()) {
                fieldValidationBuilder = stringValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type().isObject()) {
                fieldValidationBuilder = this.validateObject(formField, rootData, rootDataPath, fieldValue, fieldValidationBuilder, filtrateBuilder, wasteBuilder, validationContext);
            } else if (formField.type().isArray() || formField.type().isSet()) {
                this.validateArray(formField, rootData, rootDataPath, fieldValue, fieldValidationBuilder, filtrateBuilder, wasteBuilder, validationContext);
            } else if (formField.type().isInteger()) {
                fieldValidationBuilder = integerValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type().isDecimal()) {
                fieldValidationBuilder = decimalValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type().isBoolean()) {
                fieldValidationBuilder = booleanValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type().isDate()) {
                fieldValidationBuilder = dateValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type().isDatetime()) {
                fieldValidationBuilder = datetimeValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
            } else if (formField.type() != Type.UNDEFINED) {
                throw new RuntimeException("Not supported type = " + formField.type());
            }
            fieldValidationBuilder = optionsValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder, this, validationContext);
            equalsValidator.validate(formField, rootData, fieldValue, fieldValidationBuilder);
            if (returnFiltrate.booleanValue() && fieldValidationBuilder.isValid() && fieldValidationBuilder.addParamToFiltrate()) {
                filtrateBuilder.put(formField.name(), fieldValue);
            }
        }
        if (returnWaste.booleanValue() && fieldValidationBuilder.containsViolations()) {
            wasteBuilder.add(fieldValidationBuilder.path(rootDataPath).description((String)formField.asJsonObject().get("desc", JsonValue.EMPTY_STRING).getValue(String.class)).badValue(fieldValue == null ? JsonValue.NULL : fieldValue).build());
        }
    }

    private FormFieldValidationResult.Builder validateObject(FormField objectFormField, JsonObject rootData, JsonArray rootDataPath, JsonValue fieldValue, FormFieldValidationResult.Builder fieldValidationBuilder, JsonObject.JsonObjectBuilder filtrateBuilder, Waste.Builder wasteBuilder, ValidationContext validationContext) {
        boolean returnWaste;
        boolean returnFiltrate = filtrateBuilder != null;
        boolean bl = returnWaste = wasteBuilder != null;
        if (fieldValue.getValue() != null) {
            if (fieldValue.is(JsonObject.class)) {
                FormFields formFields;
                Form form = objectFormField.form();
                FormFields formFields2 = formFields = form != null ? form.formFields() : null;
                if (formFields != null) {
                    fieldValidationBuilder.addParamToFiltrate(false);
                    FilterResult filterResult = this.filter((ValueFormat)objectFormField.asJsonObject().as(ValueFormat.class), rootData, rootDataPath, (JsonObject)fieldValue.getValue(JsonObject.class), returnFiltrate, wasteBuilder, validationContext);
                    if (returnFiltrate) {
                        filtrateBuilder.put(objectFormField.name(), filterResult.filtrateAsJsonValue());
                    }
                }
            } else {
                fieldValidationBuilder.addParamToFiltrate(false);
                if (returnWaste) {
                    fieldValidationBuilder.add("type", Type.OBJECT);
                }
            }
        }
        return fieldValidationBuilder;
    }

    private FormFieldValidationResult.Builder validateArray(FormField formField, JsonObject rootData, JsonArray rootDataPath, JsonValue fieldValue, FormFieldValidationResult.Builder fieldValidationBuilder, JsonObject.JsonObjectBuilder filtrateBuilder, Waste.Builder wasteBuilder, ValidationContext validationContext) {
        boolean returnFiltrate;
        boolean returnWaste = wasteBuilder != null;
        boolean bl = returnFiltrate = filtrateBuilder != null;
        if (fieldValue.is(JsonArray.class)) {
            if (formField.type().isSet() && !JsonArraySet.isSet((JsonArray)((JsonArray)fieldValue.getValue(JsonArray.class)))) {
                this.addBadSet(returnWaste, fieldValidationBuilder);
            } else {
                fieldValidationBuilder = minSizeValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
                fieldValidationBuilder = maxSizeValidator.validate(formField, fieldValue, returnWaste, fieldValidationBuilder);
                fieldValidationBuilder.addParamToFiltrate(false);
                if (fieldValue.getValue(JsonArray.class) != null) {
                    JsonArray.JsonArrayBuilder arrayFiltrateBuilder;
                    JsonArray.JsonArrayBuilder jsonArrayBuilder = arrayFiltrateBuilder = returnFiltrate ? JsonArray.EMPTY.builder() : null;
                    if (formField.eform() != null) {
                        int i = 0;
                        for (JsonValue element : ((JsonArray)fieldValue.getValue(JsonArray.class)).asList()) {
                            this.validateEform(formField, rootData, rootDataPath.add(Integer.valueOf(i++)), element, wasteBuilder, arrayFiltrateBuilder, validationContext);
                        }
                    } else if (formField.element() != null) {
                        int i = 0;
                        for (JsonValue element : ((JsonArray)fieldValue.getValue(JsonArray.class)).asList()) {
                            this.validateElement(formField, rootData, rootDataPath.add(Integer.valueOf(i++)), element, wasteBuilder, arrayFiltrateBuilder, validationContext);
                        }
                    }
                    if (returnFiltrate) {
                        filtrateBuilder.put(formField.name(), arrayFiltrateBuilder.build());
                    }
                }
            }
        } else {
            fieldValidationBuilder.addParamToFiltrate(false);
            if (returnWaste) {
                fieldValidationBuilder.add("type", formField.type());
            }
        }
        return fieldValidationBuilder;
    }

    private void validateEform(FormField formField, JsonObject rootData, JsonArray rootDataPath, JsonValue element, Waste.Builder wasteBuilder, JsonArray.JsonArrayBuilder filtrateBuilder, ValidationContext validationContext) {
        boolean returnWaste;
        boolean returnFiltrate = filtrateBuilder != null;
        boolean bl = returnWaste = wasteBuilder != null;
        if (element.is(JsonObject.class)) {
            FilterResult filterResult = this.filter(ValueFormat.EMPTY.builder().type(Type.OBJECT).form(formField.eform()).build(), rootData, rootDataPath, (JsonObject)element.getValue(JsonObject.class), returnFiltrate, wasteBuilder, validationContext);
            if (returnFiltrate) {
                filtrateBuilder.add(filterResult.filtrateAsJsonValue());
            }
        } else if (returnWaste) {
            FormFieldValidationResult formFieldValidationResult = FormFieldValidationResult.builder().path(rootDataPath).badValue(element).add("type", Type.OBJECT).build();
            wasteBuilder.add(formFieldValidationResult);
        }
    }

    private void validateElement(FormField formField, JsonObject rootData, JsonArray rootDataPath, JsonValue element, Waste.Builder wasteBuilder, JsonArray.JsonArrayBuilder filtrateBuilder, ValidationContext validationContext) {
        boolean returnFiltrate = filtrateBuilder != null;
        boolean returnWaste = wasteBuilder != null;
        Form wrapperForm = Form.EMPTY.builder().value(FormFields.EMPTY.builder().add((FormField)formField.element().asJsonObject().put("name", "element").as(FormField.class)).build()).build();
        FilterResult filterResult = this.filter(ValueFormat.EMPTY.builder().type(Type.OBJECT).form(wrapperForm).build(), rootData, rootDataPath, JsonObject.EMPTY.put("element", element), returnFiltrate, wasteBuilder, validationContext, false);
        if (returnFiltrate) {
            filtrateBuilder.add(filterResult.filtrateAsJsonValue().get("element", JsonValue.NULL));
        }
    }

    private void addBadSet(boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        fieldValidationBuilder.addParamToFiltrate(false);
        if (returnWaste) {
            fieldValidationBuilder.add("type", Type.SET);
        }
    }

    private JsonArray supportedParams(JsonArray formFields) {
        JsonArray supportedParams = JsonArray.EMPTY;
        for (JsonValue param : formFields.asList()) {
            supportedParams = supportedParams.add(param.get("name"));
        }
        return supportedParams;
    }
}

