/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.filter.result;

import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectSupport;
import com.zuunr.json.JsonValue;
import java.util.ArrayList;

public class Waste
implements JsonObjectSupport {
    private JsonArray wasteItems;
    private ArrayList<FormFieldValidationResult> formFieldValidationResultList;

    private Waste(ArrayList<FormFieldValidationResult> wasteItemsList) {
        this.formFieldValidationResultList = wasteItemsList;
        this.wasteItems = JsonArray.EMPTY;
        for (int i = 0; i < wasteItemsList.size(); ++i) {
            this.wasteItems = this.wasteItems.add(wasteItemsList.get(i).asJsonValue());
        }
    }

    public Waste(JsonArray wasteItems) {
        this.wasteItems = wasteItems;
    }

    public boolean isEmpty() {
        return this.wasteItemsSize() == 0;
    }

    public JsonObject asJsonObject() {
        return JsonObject.EMPTY.put("paths", this.wasteItems);
    }

    public JsonValue asJsonValue() {
        return this.asJsonObject().jsonValue();
    }

    public int wasteItemsSize() {
        return this.formFieldValidationResultList.size();
    }

    public FormFieldValidationResult getWasteItem(int i) {
        return this.formFieldValidationResultList.get(i);
    }

    public Waste prependToAllWasteItemsPaths(JsonValue nameOrIndex) {
        Builder wasteBuilder = Waste.builder();
        for (int i = 0; i < this.wasteItemsSize(); ++i) {
            FormFieldValidationResult formFieldValidationResult = this.getWasteItem(i);
            FormFieldValidationResult.Builder wasteItemBuilder = FormFieldValidationResult.builder(formFieldValidationResult).path(formFieldValidationResult.path.addFirst(nameOrIndex));
            wasteBuilder.add(wasteItemBuilder.build());
        }
        return wasteBuilder.build();
    }

    public Waste removeFirstInAllWasteItemsPaths() {
        Builder wasteBuilder = Waste.builder();
        for (int i = 0; i < this.wasteItemsSize(); ++i) {
            FormFieldValidationResult formFieldValidationResult = this.getWasteItem(i);
            FormFieldValidationResult.Builder wasteItemBuilder = FormFieldValidationResult.builder(formFieldValidationResult).path(formFieldValidationResult.path.tail());
            wasteBuilder.add(wasteItemBuilder.build());
        }
        return wasteBuilder.build();
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ArrayList<FormFieldValidationResult> internal = new ArrayList();

        public Builder add(FormFieldValidationResult formFieldValidationResult) {
            this.internal.add(formFieldValidationResult);
            return this;
        }

        public void addAllWasteItemsOf(Waste waste) {
            this.internal.addAll(waste.formFieldValidationResultList);
        }

        public Waste build() {
            return new Waste(this.internal);
        }
    }
}

