/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.formfield;

import com.zuunr.forms.formfield.FormFieldMember;
import com.zuunr.forms.formfield.Type;
import com.zuunr.forms.formfield.options.AggregatedValidationSteps;
import com.zuunr.forms.formfield.options.Option;
import com.zuunr.forms.formfield.options.Value;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectSupport;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;

public class Options
extends FormFieldMember
implements JsonObjectSupport {
    private AggregatedValidationSteps aggregatedValidationSteps;
    private JsonObject perLabel;

    private Options(JsonValue in) {
        JsonArray aggregationValidationStepsJsonArray;
        JsonObject inObject = (JsonObject)in.getValue(JsonObject.class);
        JsonObject.JsonObjectBuilder jsonObjectBuilder = JsonObject.EMPTY.builder();
        JsonObject.JsonObjectBuilder perLabelBuilder = JsonObject.EMPTY.builder();
        JsonValue value = inObject.get("value");
        if (value != null) {
            for (Option option : value.asList(Option.class)) {
                perLabelBuilder.put(option.label(), (JsonValueSupport)option);
            }
            jsonObjectBuilder.put("value", (JsonArray)value.getValue(JsonArray.class));
        }
        if ((aggregationValidationStepsJsonArray = Options.aggregateValidationSteps(inObject)) != null) {
            jsonObjectBuilder.put("aggregatedValidationSteps", aggregationValidationStepsJsonArray);
            this.aggregatedValidationSteps = (AggregatedValidationSteps)aggregationValidationStepsJsonArray.as(AggregatedValidationSteps.class);
        }
        this.perLabel = perLabelBuilder.build();
        this.jsonValue = jsonObjectBuilder.build().jsonValue();
    }

    public JsonObject asJsonObject() {
        return (JsonObject)this.jsonValue.getValue(JsonObject.class);
    }

    public Type type() {
        return (Type)this.asJsonObject().get("type").as(Type.class);
    }

    public Value value() {
        return (Value)this.jsonValue.get("value").as(Value.class);
    }

    private static JsonArray aggregateValidationSteps(JsonObject options) {
        JsonArray steps = null;
        for (Option option : options.get("value").asList(Option.class)) {
            if (option.validationSteps() == null) continue;
            if (steps == null) {
                steps = JsonArray.EMPTY;
            }
            for (int validationStepIndex = 0; validationStepIndex < option.validationSteps().asJsonArray().size(); ++validationStepIndex) {
                steps = steps.put(JsonArray.of((Object[])new Object[]{validationStepIndex, option.label()}), option.validationSteps().asList().get(validationStepIndex).asJsonObject().put("label", option.label()));
            }
        }
        return steps;
    }

    public AggregatedValidationSteps aggregatedValidationSteps() {
        return this.aggregatedValidationSteps;
    }

    public Option getOption(String label) {
        return (Option)this.perLabel.get(label, JsonValue.NULL).as(Option.class);
    }

    public JsonObject perLabel() {
        return this.perLabel;
    }

    public static Builder builder() {
        return new Builder(JsonObject.EMPTY);
    }

    public static final class Builder {
        protected JsonObject.JsonObjectBuilder jsonObjectBuilder;

        private Builder(JsonObject jsonObject) {
            this.jsonObjectBuilder = jsonObject.builder();
        }

        public Builder value(JsonArray value) {
            this.jsonObjectBuilder.put("value", value);
            return this;
        }

        public Builder value(Value value) {
            this.jsonObjectBuilder.put("value", (JsonValueSupport)value);
            return this;
        }

        public Options build() {
            return new Options(this.jsonObjectBuilder.build().jsonValue());
        }
    }
}

