/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.formfield;

import com.zuunr.forms.formfield.FormFieldMember;
import com.zuunr.json.JsonValue;

public final class Type
extends FormFieldMember {
    public static final Type STRING = (Type)JsonValue.of((String)"string").as(Type.class);
    public static final Type INTEGER = (Type)JsonValue.of((String)"integer").as(Type.class);
    public static final Type BOOLEAN = (Type)JsonValue.of((String)"boolean").as(Type.class);
    public static final Type DECIMAL = (Type)JsonValue.of((String)"decimal").as(Type.class);
    public static final Type ARRAY = (Type)JsonValue.of((String)"array").as(Type.class);
    public static final Type SET = (Type)JsonValue.of((String)"set").as(Type.class);
    public static final Type OBJECT = (Type)JsonValue.of((String)"object").as(Type.class);
    public static final Type DATE = (Type)JsonValue.of((String)"date").as(Type.class);
    public static final Type DATETIME = (Type)JsonValue.of((String)"datetime").as(Type.class);
    public static final Type UNDEFINED = (Type)JsonValue.of((String)"undefined").as(Type.class);
    private String type;

    private Type(JsonValue jsonValue) {
        this.jsonValue = jsonValue;
        this.type = (String)jsonValue.getValue(String.class);
    }

    public boolean isInteger() {
        return Type.INTEGER.type.equals(this.type);
    }

    public boolean isString() {
        return Type.STRING.type.equals(this.type);
    }

    public boolean isBoolean() {
        return Type.BOOLEAN.type.equals(this.type);
    }

    public boolean isObject() {
        return Type.OBJECT.type.equals(this.type);
    }

    public boolean isArray() {
        return Type.ARRAY.type.equals(this.type);
    }

    public boolean isSet() {
        return Type.SET.type.equals(this.type);
    }

    public boolean isArrayOrSet() {
        return Type.ARRAY.type.equals(this.type) || Type.SET.type.equals(this.type);
    }

    public boolean isDecimal() {
        return Type.DECIMAL.type.equals(this.type);
    }

    public boolean isDate() {
        return Type.DATE.type.equals(this.type);
    }

    public boolean isDatetime() {
        return Type.DATETIME.type.equals(this.type);
    }

    public boolean isStringTypeOrSubtypeOfString() {
        return this.isString() || this.isDate() || this.isDatetime();
    }

    @Override
    public String toString() {
        return this.type;
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass() && this.type.equals(((Type)obj).type);
    }
}

