/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.formfield.options;

import com.zuunr.forms.ValueFormat;
import com.zuunr.forms.formfield.options.ValidationSteps;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectSupport;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;

public final class Option
implements JsonObjectSupport {
    private String label;
    private ValueFormat valueFormat;
    private JsonValue value;
    private JsonObject jsonObject;
    private ValidationSteps validationSteps;

    private Option(JsonValue jsonValue) {
        JsonArray validationStepsJsonArray = (JsonArray)jsonValue.get("validationSteps", JsonValue.NULL).getValue(JsonArray.class);
        this.valueFormat = (ValueFormat)jsonValue.get("format", JsonValue.NULL).as(ValueFormat.class);
        this.value = jsonValue.get("value");
        this.label = (String)jsonValue.get("label", JsonValue.NULL).getValue(String.class);
        this.jsonObject = JsonObject.EMPTY;
        this.jsonObject = this.valueFormat == null ? this.jsonObject : this.jsonObject.put("format", (JsonValueSupport)this.valueFormat);
        this.jsonObject = this.value == null ? this.jsonObject : this.jsonObject.put("value", this.value);
        JsonObject jsonObject = this.jsonObject = this.label == null ? this.jsonObject : this.jsonObject.put("label", this.label);
        if (validationStepsJsonArray != null) {
            if (this.valueFormat != null) {
                validationStepsJsonArray = validationStepsJsonArray.add(JsonObject.EMPTY.put("format", (JsonValueSupport)this.valueFormat));
            }
            this.validationSteps = (ValidationSteps)validationStepsJsonArray.as(ValidationSteps.class);
            this.jsonObject = this.jsonObject.put("validationSteps", (JsonValueSupport)this.validationSteps);
        }
    }

    public String label() {
        return this.label;
    }

    public ValueFormat format() {
        return this.valueFormat;
    }

    public JsonValue value() {
        return this.value;
    }

    public JsonObject asJsonObject() {
        return this.jsonObject;
    }

    public JsonValue asJsonValue() {
        return this.jsonObject.jsonValue();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((Option)object).asJsonObject().equals((Object)this.jsonObject);
    }

    public ValidationSteps validationSteps() {
        return this.validationSteps;
    }

    public static Builder builder() {
        return new Builder(JsonObject.EMPTY);
    }

    public static final class Builder {
        JsonObject.JsonObjectBuilder jsonObjectBuilder;

        private Builder(JsonObject jsonObject) {
            this.jsonObjectBuilder = jsonObject.builder();
        }

        public Builder label(String label) {
            this.jsonObjectBuilder.put("label", label);
            return this;
        }

        public Builder format(ValueFormat valueFormat) {
            this.jsonObjectBuilder.put("format", (JsonValueSupport)valueFormat);
            return this;
        }

        public Builder validationSteps(ValidationSteps validationSteps) {
            this.jsonObjectBuilder.put("validationSteps", (JsonValueSupport)validationSteps);
            return this;
        }

        public Builder value(JsonValue value) {
            this.jsonObjectBuilder.put("value", value);
            return this;
        }

        public Option build() {
            return (Option)this.jsonObjectBuilder.build().as(Option.class);
        }
    }
}

