/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.generation;

import com.zuunr.forms.FormField;
import com.zuunr.forms.generation.ArrayMerger;
import com.zuunr.forms.generation.DateMerger;
import com.zuunr.forms.generation.DecimalMerger;
import com.zuunr.forms.generation.EqualsMerger;
import com.zuunr.forms.generation.IntegerMerger;
import com.zuunr.forms.generation.MergeStrategy;
import com.zuunr.forms.generation.ObjectMerger;
import com.zuunr.forms.generation.OptionsMerger;
import com.zuunr.forms.generation.StringMerger;
import com.zuunr.forms.generation.TypeMerger;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectMerger;

public class FieldMerger {
    private static final JsonObjectMerger jsonObjectMerger = new JsonObjectMerger();
    private static final ObjectMerger objectMerger = new ObjectMerger();
    private static final StringMerger stringMerger = new StringMerger();
    private static final ArrayMerger arrayMerger = new ArrayMerger();
    private static final EqualsMerger equalsMerger = new EqualsMerger();
    private static final TypeMerger typeMerger = new TypeMerger();
    private static final IntegerMerger integerMerger = new IntegerMerger();
    private static final DecimalMerger decimalMerger = new DecimalMerger();
    private static final DateMerger dateMerger = new DateMerger();
    private static final OptionsMerger optionsMerger = new OptionsMerger();

    public FormField mergeFormField(FormField formField1, FormField formField2, MergeStrategy mergeStrategy) {
        FormField result;
        if (mergeStrategy.hardenFormField.booleanValue()) {
            result = formField1 == null ? formField2 : (formField2 == null ? formField1 : ((FormField)this.mergeFormFieldInternal(formField1, formField2, mergeStrategy).as(FormField.class)).builder().required(formField1 != null && formField1.required() != null && formField1.required() != false || formField2 != null && formField2.required() != null && formField2.required() != false).build());
        } else if (mergeStrategy.patchFormField.booleanValue()) {
            result = formField1 == null ? null : (formField2 == null ? formField1 : ((FormField)this.mergeFormFieldInternal(formField1, formField2, mergeStrategy).as(FormField.class)).builder().type(formField1.type()).required(formField1.required() != null && formField1.required() != false).build());
        } else if (mergeStrategy == MergeStrategy.SOFTEN) {
            Boolean required = formField1 != null && formField2 != null && formField1.required() != null && formField1.required() != false && formField2.required() != null && formField2.required() != false;
            result = ((FormField)this.mergeFormFieldInternal(formField1, formField2, mergeStrategy).as(FormField.class)).builder().required(required).build();
        } else {
            throw new RuntimeException("Only HARDEN, PATCH and SOFTEN is supported");
        }
        return result;
    }

    private JsonObject mergeFormFieldInternal(FormField formField1, FormField formField2, MergeStrategy mergeStrategy) {
        JsonObject result;
        if (mergeStrategy.patchFormField.booleanValue()) {
            String type = formField2.type() == null ? formField1.type().toString() : formField2.type().toString();
            result = jsonObjectMerger.merge(formField1.asJsonObject(), formField2.asJsonObject());
            if ("object".equals(type)) {
                result = objectMerger.merge(formField1, formField2, result, mergeStrategy);
            } else if ("array".equals(type) || "set".equals(type)) {
                result = arrayMerger.mergeArray(formField1, formField2, result, mergeStrategy);
            }
        } else if (mergeStrategy.softenFormField.booleanValue()) {
            if (formField1 == null) {
                formField1 = formField2;
            } else if (formField2 == null) {
                formField2 = formField1;
            }
            String name = formField1.name() != null ? formField1.name() : formField2.name();
            result = JsonObject.EMPTY.put("name", name);
            result = result.put("required", formField1.required() != null && formField1.required() != false && formField2.required() != null && formField2.required() != false);
            result = result.put("nullable", formField1.nullable() != null && formField1.nullable() != false || formField2.nullable() != null && formField2.nullable() != false);
            JsonObject r = result = result.put("mustBeNull", formField1.mustBeNull() != null && formField1.mustBeNull() != false && formField2.mustBeNull() != null && formField2.mustBeNull() != false);
            result = equalsMerger.merge(formField1.asJsonObject(), formField2.asJsonObject(), result);
            result = typeMerger.merge(formField1.asJsonObject(), formField2.asJsonObject(), result, mergeStrategy);
            String type = (String)result.get("type", "string").getValue(String.class);
            if ("string".equals(type)) {
                result = stringMerger.mergeString(formField1, formField2, mergeStrategy, result);
            } else if ("integer".equals(type)) {
                result = integerMerger.merge(formField1, formField2, result, mergeStrategy);
            } else if ("decimal".equals(type)) {
                result = decimalMerger.merge(formField1, formField2, result, mergeStrategy);
            } else if ("object".equals(type)) {
                result = objectMerger.merge(formField1, formField2, result, mergeStrategy);
            } else if ("array".equals(type) || "set".equals(type)) {
                result = arrayMerger.mergeArray(formField1, formField2, result, mergeStrategy);
            } else if ("date".equals(type)) {
                result = dateMerger.mergeDate(formField1, formField2, result, mergeStrategy);
            } else if ("datetime".equals(type)) {
                result = dateMerger.mergeDate(formField1, formField2, result, mergeStrategy);
            }
            result = optionsMerger.soften(formField1, formField2, result);
        } else if (mergeStrategy.hardenFormField.booleanValue()) {
            if (formField1 == null) {
                formField1 = formField2;
            } else if (formField2 == null) {
                formField2 = formField1;
            }
            String name = formField1.name() != null ? formField1.name() : formField2.name();
            result = JsonObject.EMPTY.put("name", name);
            Boolean required = formField1.required() != null && formField1.required() != false || formField2.required() != null && formField2.required() != false;
            result = result.put("required", required.booleanValue());
            Boolean nullable = formField1 != null && formField1.nullable() != null && formField1.nullable() != false && formField2 != null && formField2.nullable() != null && formField2.nullable() != false;
            result = result.put("nullable", nullable.booleanValue());
            Boolean mustBeNull = formField1.mustBeNull() != null && formField1.mustBeNull() != false || formField2.mustBeNull() != null && formField2.mustBeNull() != false;
            result = result.put("mustBeNull", mustBeNull.booleanValue());
            if (mustBeNull.booleanValue() && !nullable.booleanValue() && required.booleanValue()) {
                result = null;
            } else {
                JsonObject r = result;
                result = equalsMerger.merge(formField1.asJsonObject(), formField2.asJsonObject(), result);
                result = typeMerger.merge(formField1.asJsonObject(), formField2.asJsonObject(), result, mergeStrategy);
                String type = (String)result.get("type", "string").getValue(String.class);
                if ("string".equals(type)) {
                    result = stringMerger.mergeString(formField1, formField2, mergeStrategy, result);
                } else if ("integer".equals(type)) {
                    result = integerMerger.merge(formField1, formField2, result, mergeStrategy);
                } else if ("decimal".equals(type)) {
                    result = decimalMerger.merge(formField1, formField2, result, mergeStrategy);
                } else if ("object".equals(type)) {
                    result = objectMerger.merge(formField1, formField2, result, mergeStrategy);
                } else if ("array".equals(type) || "set".equals(type)) {
                    result = arrayMerger.mergeArray(formField1, formField2, result, mergeStrategy);
                } else if ("date".equals(type)) {
                    result = dateMerger.mergeDate(formField1, formField2, result, mergeStrategy);
                }
            }
            result = optionsMerger.harden(formField1, formField2, result);
        } else {
            throw new RuntimeException("Merge strategy is not implemented");
        }
        return result;
    }
}

