/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.generation;

import com.zuunr.forms.Form;
import com.zuunr.forms.FormField;
import com.zuunr.forms.FormFields;
import com.zuunr.forms.formfield.Type;
import com.zuunr.forms.generation.FieldMerger;
import com.zuunr.forms.generation.MergeStrategy;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectMerger;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;
import java.util.Comparator;

public class FormMerger {
    protected static final JsonArray form_value = JsonArray.of((Object[])new Object[]{"form", "value"});
    protected static final JsonArray eform_value = JsonArray.of((Object[])new Object[]{"eform"}).add("value");
    protected static final JsonObjectMerger jsonObjectMerger = new JsonObjectMerger();
    protected static final Comparator formFieldComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            JsonObject formField1 = (JsonObject)((JsonValue)o1).getValue(JsonObject.class);
            JsonObject formField2 = (JsonObject)((JsonValue)o2).getValue(JsonObject.class);
            int result = ((String)formField1.get("name").getValue(String.class)).compareTo((String)formField2.get("name").getValue(String.class));
            if (result == 0) {
                throw new RuntimeException("There can never be more than one form field per builder");
            }
            return result;
        }
    };
    private FieldMerger fieldMerger = new FieldMerger();

    public FormFields merge(Form form1, Form form2, MergeStrategy mergeStrategy) {
        FormFields formFields1 = form1.formFields();
        FormFields formFields2 = form2.formFields();
        FormFields.FormFieldsBuilder resultBuilder = FormFields.EMPTY.builder();
        boolean continueMergeFromForm2 = true;
        JsonObject formFields2ByName = formFields2.formFieldsByName();
        for (FormField formField1 : formFields1.asList()) {
            FormField formField2;
            FormField mergedFormField = null;
            if (mergeStrategy.patchForm.booleanValue()) {
                formField2 = formFields2.of(formField1.name());
                mergedFormField = formField2 == null ? formField1 : this.fieldMerger.mergeFormField(formField1, formField2, mergeStrategy);
            } else if (mergeStrategy.softenForm.booleanValue()) {
                formField2 = formFields2.of(formField1.name());
                mergedFormField = this.fieldMerger.mergeFormField(formField1, formField2, mergeStrategy);
            } else if (mergeStrategy.hardenForm.booleanValue()) {
                formField2 = formFields2.of(formField1.name());
                if (formField2 == null) {
                    if (form2.exclusive().booleanValue()) {
                        if (formField1.required() != null && formField1.required().booleanValue()) {
                            resultBuilder = FormFields.EMPTY.builder();
                            continueMergeFromForm2 = false;
                            break;
                        }
                    } else {
                        mergedFormField = formField1;
                    }
                } else if (formField2 != null) {
                    mergedFormField = this.fieldMerger.mergeFormField(formField1, formField2, mergeStrategy);
                }
            } else {
                throw new RuntimeException("Strategy not supported");
            }
            if (mergedFormField != null && mergedFormField.type() == Type.UNDEFINED) {
                continueMergeFromForm2 = false;
                resultBuilder = null;
                break;
            }
            if (mergedFormField != null) {
                resultBuilder.add(mergedFormField);
            }
            formFields2ByName = formFields2ByName.remove(formField1.name());
        }
        if (continueMergeFromForm2 && !mergeStrategy.patchForm.booleanValue()) {
            if (mergeStrategy == MergeStrategy.SOFTEN) {
                for (FormField formField2 : formFields2ByName.values().asList(FormField.class)) {
                    if (formField2.builder() == null) continue;
                    resultBuilder.add(this.fieldMerger.mergeFormField(formFields1.of(formField2.name()), formField2, mergeStrategy));
                }
            } else if (mergeStrategy.hardenForm.booleanValue()) {
                for (FormField formField2 : formFields2ByName.values().asList(FormField.class)) {
                    if (formField2.required() != null && formField2.required().booleanValue() && (form2.exclusive().booleanValue() || form1.exclusive().booleanValue())) {
                        resultBuilder = FormFields.EMPTY.builder();
                        break;
                    }
                    if (form1.exclusive().booleanValue() || formField2.builder() == null) continue;
                    resultBuilder.add(this.fieldMerger.mergeFormField(formFields1.of(formField2.name()), formField2, mergeStrategy));
                }
            } else {
                throw new RuntimeException("strategy not supported");
            }
        }
        return resultBuilder == null ? null : resultBuilder.buildSortedByName();
    }

    protected JsonObject formFieldsAsJsonObject(JsonArray formFields) {
        return this.formFieldsAsJsonObject(formFields, false);
    }

    public JsonObject formFieldsAsJsonObject(JsonArray formFields, boolean recursive) {
        JsonObject.JsonObjectBuilder builder = JsonObject.EMPTY.builder();
        for (int i = 0; i < formFields.size(); ++i) {
            JsonObject formField = (JsonObject)formFields.get(i).getValue(JsonObject.class);
            formField.toString();
            if (recursive) {
                JsonObject eform;
                JsonArray value;
                String type = (String)formField.get("type", JsonValue.NULL).getValue(String.class);
                if ("object".equals(type)) {
                    JsonObject form = (JsonObject)formField.get("form", JsonValue.NULL).getValue(JsonObject.class);
                    if (form != null && (value = (JsonArray)form.get("value", JsonValue.NULL).getValue(JsonArray.class)) != null) {
                        JsonObject valueAsJsonObject = this.formFieldsAsJsonObject(value, recursive);
                        form = form.put("value", valueAsJsonObject);
                        formField = formField.put("form", form);
                        formField.toString();
                    }
                } else if (("array".equals(type) || "set".equals(type)) && (eform = (JsonObject)formField.get("eform", JsonValue.NULL).getValue(JsonObject.class)) != null && (value = (JsonArray)eform.get("value", JsonValue.NULL).getValue(JsonArray.class)) != null) {
                    eform = eform.put("value", this.formFieldsAsJsonObject(value, recursive));
                    formField = formField.put("eform", eform);
                    formField.toString();
                }
            }
            builder.put((String)formField.get("name").getValue(String.class), formField);
        }
        return builder.build();
    }

    public Form mergeSubforms(Form subform1, Form subform2) {
        Form result = subform1;
        JsonObject.JsonObjectBuilder formFieldsByName = subform1.formFieldsByName().builder();
        for (FormField formField2 : subform2.formFields().asList()) {
            Form mergedForm;
            FormField formField1 = subform1.formField(formField2.name());
            if (formField1 == null) {
                formFieldsByName.put(formField2.name(), (JsonValueSupport)formField2);
                continue;
            }
            if (formField1.type().isObject() && formField1.form() != null) {
                mergedForm = this.mergeSubforms(formField1.form(), formField2.form());
                formFieldsByName.put(formField2.name(), (JsonValueSupport)formField1.builder().form(mergedForm).build());
                continue;
            }
            if (formField1.type().isArrayOrSet() && formField1.eform() != null) {
                mergedForm = this.mergeSubforms(formField1.eform(), formField2.eform());
                formFieldsByName.put(formField2.name(), (JsonValueSupport)formField1.builder().eform(mergedForm).build());
                continue;
            }
            throw new RuntimeException("Only distict subsets are supported (ie leaves must be present in only one of the subforms). formfield1 and formfield2 of same builder must be non-leaf if both are present.");
        }
        return subform1.builder().value(new FormFields.FormFieldsBuilder(formFieldsByName.build().values()).build()).build();
    }

    public Form mergeForms(Form form1, Form form2, MergeStrategy mergeStrategy) {
        Form.FormBuilder formBuilder = Form.EMPTY.builder();
        formBuilder.value(this.merge(form1, form2, mergeStrategy));
        if (mergeStrategy.hardenForm.booleanValue()) {
            formBuilder.exclusive(form1.exclusive() != false || form2.exclusive() != false);
        } else if (mergeStrategy.softenForm.booleanValue()) {
            formBuilder.exclusive(form1.exclusive() != false && form2.exclusive() != false);
        } else if (mergeStrategy.patchForm.booleanValue()) {
            formBuilder.exclusive(form1.exclusive());
        } else {
            throw new RuntimeException("Strategy not supported");
        }
        return formBuilder.build();
    }
}

