/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.generation;

import com.zuunr.forms.FormField;
import com.zuunr.forms.formfield.Pattern;
import com.zuunr.forms.generation.MergeStrategy;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;

public class PatternMerger {
    public JsonObject mergePattern(FormField formField1, FormField formField2, MergeStrategy mergeStrategy, JsonObject formFieldSoFar) {
        boolean restrictionApplicable;
        JsonObject formFieldJsonObject1 = formField1.asJsonObject();
        JsonObject formFieldJsonObject2 = formField2.asJsonObject();
        JsonObject result = formFieldSoFar;
        Boolean formField1mustBeNull = (Boolean)formFieldJsonObject1.get("mustBeNull", JsonValue.FALSE).getValue(Boolean.class);
        Boolean formField2mustBeNull = (Boolean)formFieldJsonObject2.get("mustBeNull", JsonValue.FALSE).getValue(Boolean.class);
        boolean bl = restrictionApplicable = formField1mustBeNull == false || formField2mustBeNull == false;
        if (restrictionApplicable) {
            String pattern1 = (String)formFieldJsonObject1.get("pattern", JsonValue.NULL).getValue(String.class);
            String pattern2 = (String)formFieldJsonObject2.get("pattern", JsonValue.NULL).getValue(String.class);
            if (mergeStrategy == MergeStrategy.SOFTEN) {
                if (pattern1 == null && !formField1mustBeNull.booleanValue() || pattern2 == null && !formField2mustBeNull.booleanValue()) {
                    result = result.remove("pattern");
                } else if (pattern1 == null) {
                    result = result.put("pattern", pattern2);
                } else if (pattern2 == null) {
                    result = result.put("pattern", pattern1);
                } else if (pattern1.equals(pattern2)) {
                    result = result.put("pattern", pattern1);
                } else if (".*".equals(pattern1) || ".*".equals(pattern2)) {
                    result = result.put("pattern", ".*");
                } else {
                    int index;
                    String[] statusArray = pattern1.split("[|]");
                    JsonObject patterns = JsonObject.EMPTY;
                    for (index = 0; index < statusArray.length; ++index) {
                        patterns = patterns.put(statusArray[index], statusArray[index]);
                    }
                    statusArray = pattern2.split("[|]");
                    for (index = 0; index < statusArray.length; ++index) {
                        patterns = patterns.put(statusArray[index], statusArray[index]);
                    }
                    StringBuilder builder = new StringBuilder();
                    String delimiter = "";
                    for (JsonValue jsonValue : patterns.keys().sort().asList()) {
                        String pattern = (String)jsonValue.getValue(String.class);
                        builder.append(delimiter);
                        builder.append(pattern);
                        delimiter = "|";
                    }
                    result = result.put("pattern", builder.toString());
                }
            } else {
                Pattern hardenedPattern = this.hardenPattern(formField1.pattern() == null ? formField2.pattern() : formField1.pattern(), formField2.pattern() == null ? formField1.pattern() : formField2.pattern());
                if (hardenedPattern != null) {
                    result = result.put("pattern", hardenedPattern.asString());
                }
            }
        }
        return result;
    }

    public Pattern hardenPattern(Pattern pattern1, Pattern pattern2) {
        Pattern resultingPattern = pattern1 == null ? pattern2 : (pattern2 == null ? pattern1 : (pattern1.asString().equals(".*") ? pattern2 : (pattern2.asString().equals(".*") ? pattern1 : (pattern1.equals(pattern2) ? pattern1 : pattern1))));
        return resultingPattern;
    }
}

