/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.util;

import com.zuunr.forms.Form;
import com.zuunr.forms.filter.FilterResult;
import com.zuunr.forms.filter.FormFilter;
import com.zuunr.forms.filter.result.Waste;
import com.zuunr.forms.formfield.Pattern;
import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;
import java.util.Iterator;
import java.util.Stack;

public class JsonValuePathsFinder {
    private static FormFilter formFilter = new FormFilter();
    private static FilterResult NON_EMPTY_FILTER_RESULT = new FilterResult<Object>(null, Waste.builder().add(new FormFieldValidationResult(false, JsonArray.EMPTY, "description", JsonValue.of((String)"badValue"), JsonObject.EMPTY, true)).build());
    private static JsonValue PATTERN_ANY_FIELD_NAME = JsonValue.of((String)".*");

    public JsonArray getPaths(JsonValue source, JsonArray pathsPattern, boolean includeValueLast) {
        Stack<JsonObject> stack = new Stack<JsonObject>();
        stack.push(JsonObject.EMPTY.put("pathsPattern", pathsPattern).put("source", source).put("path", JsonArray.EMPTY));
        JsonArray resultingPaths = JsonArray.EMPTY;
        while (!stack.empty()) {
            JsonObject pathPatternObject = (JsonObject)stack.pop();
            JsonArray pPattern = (JsonArray)pathPatternObject.get("pathsPattern").getValue(JsonArray.class);
            JsonArray path = (JsonArray)pathPatternObject.get("path").getValue(JsonArray.class);
            JsonValue currentSource = pathPatternObject.get("source");
            JsonValue fieldOrIndexPattern = pPattern.head();
            if (fieldOrIndexPattern.is(String.class)) {
                resultingPaths = this.handleFieldName(stack, currentSource, pPattern, fieldOrIndexPattern, includeValueLast, resultingPaths, path);
                continue;
            }
            if (fieldOrIndexPattern.is(JsonObject.class) && currentSource.is(JsonObject.class)) {
                resultingPaths = this.handleJsonObject(stack, currentSource, pPattern, fieldOrIndexPattern, includeValueLast, resultingPaths, path);
                continue;
            }
            if (!fieldOrIndexPattern.isInteger()) continue;
            resultingPaths = this.handleIndex(stack, currentSource, pPattern, fieldOrIndexPattern, includeValueLast, resultingPaths, path);
        }
        return resultingPaths;
    }

    private JsonArray handleJsonObject(Stack stack, JsonValue currentSource, JsonArray pPattern, JsonValue fieldOrIndexPattern, boolean includeValueLast, JsonArray resultingPaths, JsonArray path) {
        FilterResult result;
        JsonObject currentSourceJsonObject = (JsonObject)currentSource.getValue(JsonObject.class);
        Pattern fieldNamePattern = (Pattern)fieldOrIndexPattern.get("fieldNamePattern", PATTERN_ANY_FIELD_NAME).as(Pattern.class);
        Form form = (Form)((Object)fieldOrIndexPattern.get("objectFormat", JsonValue.NULL).as(Form.class));
        FilterResult filterResult = result = form == null ? NON_EMPTY_FILTER_RESULT : formFilter.filter(form, currentSourceJsonObject, false, true);
        if (result.waste.isEmpty()) {
            JsonArray pPatternTail = pPattern.tail();
            Iterator fieldValueIter = currentSourceJsonObject.values().iterator();
            for (JsonValue fieldName : currentSourceJsonObject.keys().asList()) {
                JsonValue fieldValue = (JsonValue)fieldValueIter.next();
                if (!fieldNamePattern.compiled().matcher((CharSequence)fieldName.getValue(String.class)).matches()) continue;
                resultingPaths = this.addToStackOrResultingPaths(stack, fieldName, fieldValue, pPatternTail, resultingPaths, path, includeValueLast);
            }
        }
        return resultingPaths;
    }

    private JsonArray handleIndex(Stack stack, JsonValue currentSource, JsonArray pPattern, JsonValue fieldOrIndexPattern, boolean includeValueLast, JsonArray resultingPaths, JsonArray path) {
        if (currentSource.is(JsonArray.class)) {
            JsonArray currentSourceJsonArray = (JsonArray)currentSource.getValue(JsonArray.class);
            Integer index = fieldOrIndexPattern.asInteger();
            JsonArray pPatternTail = pPattern.tail();
            if (index == -1) {
                int currentIndex = 0;
                for (JsonValue value : currentSourceJsonArray.asList()) {
                    resultingPaths = this.addToStackOrResultingPaths(stack, JsonValue.of((int)currentIndex), value, pPatternTail, resultingPaths, path, includeValueLast);
                    ++currentIndex;
                }
            } else if (index >= 0 && currentSourceJsonArray.size() > index) {
                JsonValue value = currentSource.get(index);
                resultingPaths = this.addToStackOrResultingPaths(stack, JsonValue.of((Integer)index), value, pPatternTail, resultingPaths, path, includeValueLast);
            }
        }
        return resultingPaths;
    }

    private JsonArray handleFieldName(Stack stack, JsonValue currentSource, JsonArray pPattern, JsonValue fieldOrIndexPattern, boolean includeValueLast, JsonArray resultingPaths, JsonArray path) {
        String keyOrIndex;
        JsonValue value;
        if ((currentSource.is(JsonObject.class) || JsonValue.NULL.equals((Object)currentSource)) && (value = currentSource.get(keyOrIndex = (String)fieldOrIndexPattern.getValue(String.class))) != null) {
            JsonArray pPatternTail = pPattern.tail();
            resultingPaths = this.addToStackOrResultingPaths(stack, fieldOrIndexPattern, value, pPatternTail, resultingPaths, path, includeValueLast);
        }
        return resultingPaths;
    }

    private JsonArray addToStackOrResultingPaths(Stack stack, JsonValue indexOrFieldToAdd, JsonValue valueOfIndex, JsonArray pPatternTail, JsonArray resultingPaths, JsonArray path, boolean includeValueLast) {
        if (pPatternTail.isEmpty()) {
            resultingPaths = this.addToResultingPaths(resultingPaths, path, indexOrFieldToAdd, (JsonValue)(includeValueLast ? valueOfIndex : null));
        } else {
            stack.push(JsonObject.EMPTY.put("pathsPattern", pPatternTail).put("path", path.add(indexOrFieldToAdd)).put("source", valueOfIndex));
        }
        return resultingPaths;
    }

    private JsonArray addToResultingPaths(JsonArray resultingPaths, JsonArray pathSoFar, JsonValue keyOrIndex, JsonValue value) {
        resultingPaths = value != null ? resultingPaths.addFirst(pathSoFar.add(keyOrIndex).add(value)) : resultingPaths.addFirst(pathSoFar.add(keyOrIndex));
        return resultingPaths;
    }
}

