/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.validation;

import com.zuunr.forms.FormField;
import com.zuunr.forms.formfield.Max;
import com.zuunr.forms.formfield.Min;
import com.zuunr.forms.formfield.Pattern;
import com.zuunr.forms.formfield.Type;
import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.json.JsonValue;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public abstract class AbstractJavaDatetimeValidator {
    public FormFieldValidationResult.Builder validate(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        Pattern pattern;
        if (formField.type().isStringTypeOrSubtypeOfString() && (pattern = formField.pattern()) != null && !pattern.compiled().matcher((CharSequence)fieldValue.getValue(String.class)).matches()) {
            fieldValidationBuilder.valid(false);
            if (returnWaste.booleanValue()) {
                fieldValidationBuilder.add("pattern", pattern.asJsonValue());
            }
        }
        if (this.isCorrectFormat(fieldValue)) {
            this.min(formField, fieldValue, returnWaste, fieldValidationBuilder);
            this.max(formField, fieldValue, returnWaste, fieldValidationBuilder);
        } else {
            fieldValidationBuilder.valid(false);
            if (returnWaste.booleanValue()) {
                fieldValidationBuilder.add("type", this.type());
            }
        }
        return fieldValidationBuilder;
    }

    public boolean isCorrectFormat(JsonValue fieldValue) {
        try {
            LocalDate.parse((CharSequence)fieldValue.getValue(String.class), this.formatter());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private FormFieldValidationResult.Builder min(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        Min min = formField.min();
        if (min != null) {
            String minString = min.asString();
            if (((String)fieldValue.getValue(String.class)).compareTo(minString) < 0) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("min", formField.asJsonObject().get("min"));
                }
            }
        }
        return fieldValidationBuilder;
    }

    private FormFieldValidationResult.Builder max(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        Max max = formField.max();
        if (max != null) {
            String maxString = max.asString();
            if (((String)fieldValue.getValue(String.class)).compareTo(maxString) > 0) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("max", formField.asJsonObject().get("max"));
                }
            }
        }
        return fieldValidationBuilder;
    }

    abstract DateTimeFormatter formatter();

    abstract Type type();
}

